/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.ArrayRecord;
import org.apache.avro.AvroTypeException;
import org.apache.avro.MapRecord;
import org.apache.avro.MapRecordEnum;
import org.apache.avro.RecordWithRequiredFields;
import org.apache.avro.Schema;
import org.apache.avro.UnionRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.test.Kind;
import org.apache.avro.test.MD5;
import org.apache.avro.test.TestRecord;
import org.apache.avro.test.TestRecordWithUnion;
import org.junit.Assert;
import org.junit.Test;

public class TestSpecificDatumWriter {
    @Test
    public void testResolveUnion() throws IOException {
        SpecificDatumWriter writer = new SpecificDatumWriter();
        Schema schema = TestRecordWithUnion.SCHEMA$;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)out);
        writer.setSchema(schema);
        TestRecordWithUnion c = TestRecordWithUnion.newBuilder().setKind(Kind.BAR).setValue("rab").build();
        writer.write((Object)c, (Encoder)encoder);
        encoder.flush();
        out.close();
        String expectedJson = String.format("{'kind':{'org.apache.avro.test.Kind':'%s'},'value':{'string':'%s'}}", c.getKind().toString(), c.getValue()).replace('\'', '\"');
        Assert.assertEquals((Object)expectedJson, (Object)out.toString("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncompleteRecord() throws IOException {
        SpecificDatumWriter writer = new SpecificDatumWriter();
        Schema schema = TestRecord.SCHEMA$;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)out);
        writer.setSchema(schema);
        TestRecord testRecord = new TestRecord();
        testRecord.setKind(Kind.BAR);
        testRecord.setHash(new MD5(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}));
        try {
            writer.write((Object)testRecord, (Encoder)encoder);
            Assert.fail((String)"Exception not thrown");
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("null value for (non-nullable) string at TestRecord.name"));
        }
        finally {
            out.close();
        }
    }

    @Test
    public void testNestedNPEErrorClarity() throws Exception {
        RecordWithRequiredFields topLevelRecord = this.buildComplexRecord();
        topLevelRecord.getUnionField().getArrayField().get(0).getMapField().get("a").setStrField(null);
        try {
            this.writeObject((IndexedRecord)topLevelRecord, false);
            Assert.fail((String)"expected to throw");
        }
        catch (NullPointerException expected) {
            Assert.assertTrue((String)("unexpected message " + expected.getMessage()), (boolean)expected.getMessage().contains("RecordWithRequiredFields.unionField[UnionRecord].arrayField[0].mapField[\"a\"].strField"));
        }
    }

    @Test
    public void testNestedNPEErrorClarityWithCustomCoders() throws Exception {
        RecordWithRequiredFields topLevelRecord = this.buildComplexRecord();
        topLevelRecord.getUnionField().getArrayField().get(0).getMapField().get("a").setEnumField(null);
        try {
            this.writeObject((IndexedRecord)topLevelRecord, true);
            Assert.fail((String)"expected to throw");
        }
        catch (NullPointerException expected) {
            Assert.assertTrue((String)("unexpected message " + expected.getMessage()), (boolean)expected.getMessage().contains("custom coders were used"));
        }
    }

    @Test
    public void testNPEForMapKeyErrorClarity() throws Exception {
        RecordWithRequiredFields topLevelRecord = this.buildComplexRecord();
        Map<String, MapRecord> map = topLevelRecord.getUnionField().getArrayField().get(0).getMapField();
        map.put(null, map.get("a"));
        try {
            this.writeObject((IndexedRecord)topLevelRecord, false);
            Assert.fail((String)"expected to throw");
        }
        catch (NullPointerException expected) {
            Assert.assertTrue((String)("unexpected message " + expected.getMessage()), (boolean)expected.getMessage().contains("null key in map at RecordWithRequiredFields.unionField[UnionRecord].arrayField[0].mapField"));
        }
    }

    @Test
    public void testNPEForMapKeyErrorClarityWithCustomCoders() throws Exception {
        RecordWithRequiredFields topLevelRecord = this.buildComplexRecord();
        Map<String, MapRecord> map = topLevelRecord.getUnionField().getArrayField().get(0).getMapField();
        map.put(null, map.get("a"));
        try {
            this.writeObject((IndexedRecord)topLevelRecord, true);
            Assert.fail((String)"expected to throw");
        }
        catch (NullPointerException expected) {
            Assert.assertTrue((String)("unexpected message " + expected.getMessage()), (boolean)expected.getMessage().contains("custom coders were used"));
        }
    }

    @Test
    public void testNestedATEErrorClarity() throws Exception {
        RecordWithRequiredFields topLevelRecord = this.buildComplexRecord();
        topLevelRecord.getUnionField().getArrayField().get(0).getMapField().get("a").setEnumField(null);
        try {
            this.writeObject((IndexedRecord)topLevelRecord, false);
            Assert.fail((String)"expected to throw");
        }
        catch (AvroTypeException expected) {
            Assert.assertTrue((String)("unexpected message " + expected.getMessage()), (boolean)expected.getMessage().contains("RecordWithRequiredFields.unionField[UnionRecord].arrayField[0].mapField[\"a\"].enumField"));
        }
    }

    @Test
    public void testNestedATEErrorClarityWithCustomCoders() throws Exception {
        RecordWithRequiredFields topLevelRecord = this.buildComplexRecord();
        topLevelRecord.getUnionField().getArrayField().get(0).getMapField().get("a").setEnumField(null);
        try {
            this.writeObject((IndexedRecord)topLevelRecord, true);
            Assert.fail((String)"expected to throw");
        }
        catch (NullPointerException expected) {
            Assert.assertTrue((String)("unexpected message " + expected.getMessage()), (boolean)expected.getMessage().contains("custom coders were used"));
        }
    }

    private RecordWithRequiredFields buildComplexRecord() {
        RecordWithRequiredFields topLevelRecord = new RecordWithRequiredFields();
        UnionRecord unionRecord = new UnionRecord();
        ArrayRecord arrayRecord1 = new ArrayRecord();
        ArrayRecord arrayRecord2 = new ArrayRecord();
        MapRecord mapRecordA = new MapRecord();
        mapRecordA.setEnumField(MapRecordEnum.B);
        mapRecordA.setStrField("4");
        arrayRecord1.setStrField("2");
        HashMap<String, MapRecord> map1 = new HashMap<String, MapRecord>();
        map1.put("a", mapRecordA);
        arrayRecord1.setMapField(map1);
        arrayRecord2.setStrField("2");
        HashMap<String, MapRecord> map2 = new HashMap<String, MapRecord>();
        map2.put("a", mapRecordA);
        arrayRecord2.setMapField(map2);
        unionRecord.setStrField("1");
        unionRecord.setArrayField(Arrays.asList(arrayRecord1, arrayRecord2));
        topLevelRecord.setStrField("0");
        topLevelRecord.setUnionField(unionRecord);
        return topLevelRecord;
    }

    private void writeObject(IndexedRecord datum, boolean useCustomCoders) throws Exception {
        this.writeObject(datum.getSchema(), datum, useCustomCoders);
    }

    private void writeObject(Schema schema, Object datum, boolean useCustomCoders) throws Exception {
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)new ByteArrayOutputStream(), null);
        SpecificData specificData = new SpecificData();
        specificData.setCustomCoders(useCustomCoders);
        SpecificDatumWriter writer = new SpecificDatumWriter(schema, specificData);
        writer.write(datum, (Encoder)encoder);
        encoder.flush();
    }
}

