/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.specific;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificCompiler {
    private final Set<Schema> queue = new HashSet<Schema>();
    private Protocol protocol;
    private VelocityEngine velocityEngine;
    private String templateDir = System.getProperty("org.apache.avro.specific.templates", "/org/apache/avro/compiler/specific/templates/java/classic/");
    private static final Set<String> RESERVED_WORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));
    private static final String FILE_HEADER = "/**\n * Autogenerated by Avro\n * \n * DO NOT EDIT DIRECTLY\n */\n";
    private static String logChuteName = null;
    private static final Schema NULL_SCHEMA = Schema.create(Schema.Type.NULL);

    public SpecificCompiler(Protocol protocol) {
        this();
        for (Schema s : protocol.getTypes()) {
            this.enqueue(s);
        }
        this.protocol = protocol;
    }

    public SpecificCompiler(Schema schema) {
        this();
        this.enqueue(schema);
        this.protocol = null;
    }

    SpecificCompiler() {
        this.initializeVelocity();
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    private void initializeVelocity() {
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.addProperty("resource.loader", "class");
        this.velocityEngine.addProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.velocityEngine.setProperty("runtime.references.strict", true);
        if (null == logChuteName) {
            try {
                new Slf4jLogChute();
                logChuteName = Slf4jLogChute.class.getName();
            }
            catch (Exception e) {
                logChuteName = "org.apache.velocity.runtime.log.NullLogChute";
            }
        }
        this.velocityEngine.setProperty("runtime.log.logsystem.class", logChuteName);
    }

    public static void compileProtocol(File src, File dest) throws IOException {
        Protocol protocol = Protocol.parse(src);
        SpecificCompiler compiler = new SpecificCompiler(protocol);
        compiler.compileToDestination(src, dest);
    }

    public static void compileSchema(File src, File dest) throws IOException {
        Schema schema = Schema.parse(src);
        SpecificCompiler compiler = new SpecificCompiler(schema);
        compiler.compileToDestination(src, dest);
    }

    private void enqueue(Schema schema) {
        if (this.queue.contains(schema)) {
            return;
        }
        switch (schema.getType()) {
            case RECORD: {
                this.queue.add(schema);
                for (Schema.Field field : schema.getFields()) {
                    this.enqueue(field.schema());
                }
                break;
            }
            case MAP: {
                this.enqueue(schema.getValueType());
                break;
            }
            case ARRAY: {
                this.enqueue(schema.getElementType());
                break;
            }
            case UNION: {
                for (Schema s : schema.getTypes()) {
                    this.enqueue(s);
                }
                break;
            }
            case ENUM: 
            case FIXED: {
                this.queue.add(schema);
                break;
            }
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case NULL: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + schema);
            }
        }
    }

    Collection<OutputFile> compile() {
        ArrayList<OutputFile> out = new ArrayList<OutputFile>();
        for (Schema schema : this.queue) {
            out.add(this.compile(schema));
        }
        if (this.protocol != null) {
            out.add(this.compileInterface(this.protocol));
        }
        return out;
    }

    public void compileToDestination(File src, File dst) throws IOException {
        for (Schema schema : this.queue) {
            OutputFile o = this.compile(schema);
            o.writeToDestination(src, dst);
        }
        if (this.protocol != null) {
            this.compileInterface(this.protocol).writeToDestination(src, dst);
        }
    }

    private String renderTemplate(String templateName, VelocityContext context) {
        Template template;
        try {
            template = this.velocityEngine.getTemplate(templateName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        StringWriter writer = new StringWriter();
        try {
            template.merge(context, writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    OutputFile compileInterface(Protocol protocol) {
        VelocityContext context = new VelocityContext();
        context.put("protocol", protocol);
        context.put("this", this);
        String out = this.renderTemplate(this.templateDir + "protocol.vm", context);
        OutputFile outputFile = new OutputFile();
        String mangledName = SpecificCompiler.mangle(protocol.getName());
        outputFile.path = SpecificCompiler.makePath(mangledName, protocol.getNamespace());
        outputFile.contents = out;
        return outputFile;
    }

    static String makePath(String name, String space) {
        if (space == null || space.isEmpty()) {
            return name + ".java";
        }
        return space.replace('.', File.separatorChar) + File.separatorChar + name + ".java";
    }

    OutputFile compile(Schema schema) {
        String output = "";
        VelocityContext context = new VelocityContext();
        context.put("this", this);
        context.put("schema", schema);
        switch (schema.getType()) {
            case RECORD: {
                output = this.renderTemplate(this.templateDir + "record.vm", context);
                break;
            }
            case ENUM: {
                output = this.renderTemplate(this.templateDir + "enum.vm", context);
                break;
            }
            case FIXED: {
                output = this.renderTemplate(this.templateDir + "fixed.vm", context);
                break;
            }
            case BOOLEAN: 
            case NULL: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + schema);
            }
        }
        OutputFile outputFile = new OutputFile();
        String name = SpecificCompiler.mangle(schema.getName());
        outputFile.path = SpecificCompiler.makePath(name, schema.getNamespace());
        outputFile.contents = output;
        return outputFile;
    }

    public static String javaType(Schema schema) {
        switch (schema.getType()) {
            case RECORD: 
            case ENUM: 
            case FIXED: {
                return SpecificCompiler.mangle(schema.getFullName());
            }
            case ARRAY: {
                return "java.util.List<" + SpecificCompiler.javaType(schema.getElementType()) + ">";
            }
            case MAP: {
                return "java.util.Map<java.lang.CharSequence," + SpecificCompiler.javaType(schema.getValueType()) + ">";
            }
            case UNION: {
                List<Schema> types = schema.getTypes();
                if (types.size() == 2 && types.contains(NULL_SCHEMA)) {
                    return SpecificCompiler.javaType(types.get(types.get(0).equals(NULL_SCHEMA) ? 1 : 0));
                }
                return "java.lang.Object";
            }
            case STRING: {
                return "java.lang.CharSequence";
            }
            case BYTES: {
                return "java.nio.ByteBuffer";
            }
            case INT: {
                return "java.lang.Integer";
            }
            case LONG: {
                return "java.lang.Long";
            }
            case FLOAT: {
                return "java.lang.Float";
            }
            case DOUBLE: {
                return "java.lang.Double";
            }
            case BOOLEAN: {
                return "java.lang.Boolean";
            }
            case NULL: {
                return "java.lang.Void";
            }
        }
        throw new RuntimeException("Unknown type: " + schema);
    }

    public static String javaUnbox(Schema schema) {
        switch (schema.getType()) {
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case BOOLEAN: {
                return "boolean";
            }
        }
        return SpecificCompiler.javaType(schema);
    }

    public static String javaEscape(Object o) {
        return o.toString().replace("\"", "\\\"");
    }

    public static String escapeForJavadoc(String s) {
        return s.replace("*/", "*&#47;");
    }

    public static String nullToEmpty(String x) {
        return x == null ? "" : x;
    }

    public static String mangle(String word) {
        if (RESERVED_WORDS.contains(word)) {
            return word + "$";
        }
        return word;
    }

    public static void main(String[] args) throws Exception {
        SpecificCompiler.compileProtocol(new File(args[0]), new File(args[1]));
    }

    public static final class Slf4jLogChute
    implements LogChute {
        private Logger logger = LoggerFactory.getLogger("AvroVelocityLogChute");

        @Override
        public void init(RuntimeServices rs) throws Exception {
        }

        @Override
        public void log(int level, String message) {
            switch (level) {
                case 0: {
                    this.logger.debug(message);
                    break;
                }
                case -1: {
                    this.logger.trace(message);
                    break;
                }
                case 2: {
                    this.logger.warn(message);
                    break;
                }
                case 3: {
                    this.logger.error(message);
                    break;
                }
                default: {
                    this.logger.info(message);
                }
            }
        }

        @Override
        public void log(int level, String message, Throwable t) {
            switch (level) {
                case 0: {
                    this.logger.debug(message, t);
                    break;
                }
                case -1: {
                    this.logger.trace(message, t);
                    break;
                }
                case 2: {
                    this.logger.warn(message, t);
                    break;
                }
                case 3: {
                    this.logger.error(message, t);
                    break;
                }
                default: {
                    this.logger.info(message, t);
                }
            }
        }

        @Override
        public boolean isLevelEnabled(int level) {
            switch (level) {
                case 0: {
                    return this.logger.isDebugEnabled();
                }
                case -1: {
                    return this.logger.isTraceEnabled();
                }
                case 2: {
                    return this.logger.isWarnEnabled();
                }
                case 3: {
                    return this.logger.isErrorEnabled();
                }
            }
            return this.logger.isInfoEnabled();
        }
    }

    static class OutputFile {
        String path;
        String contents;

        OutputFile() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        File writeToDestination(File src, File destDir) throws IOException {
            File f = new File(destDir, this.path);
            if (src != null && f.exists() && f.lastModified() >= src.lastModified()) {
                return f;
            }
            f.getParentFile().mkdirs();
            FileWriter fw = new FileWriter(f);
            try {
                fw.write(SpecificCompiler.FILE_HEADER);
                fw.write(this.contents);
            }
            finally {
                fw.close();
            }
            return f;
        }
    }
}

