/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.specific;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;

public class SpecificRequestor
extends Requestor
implements InvocationHandler {
    public SpecificRequestor(Class<?> iface, Transceiver transceiver) throws IOException {
        this(SpecificData.get().getProtocol(iface), transceiver);
    }

    protected SpecificRequestor(Protocol protocol, Transceiver transceiver) throws IOException {
        super(protocol, transceiver);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.request(method.getName(), args);
    }

    protected DatumWriter<Object> getDatumWriter(Schema schema) {
        return new SpecificDatumWriter<Object>(schema);
    }

    protected DatumReader<Object> getDatumReader(Schema schema) {
        return new SpecificDatumReader<Object>(schema);
    }

    @Override
    public void writeRequest(Schema schema, Object request, Encoder out) throws IOException {
        Object[] args = (Object[])request;
        int i = 0;
        for (Schema.Field param : schema.getFields()) {
            this.getDatumWriter(param.schema()).write(args[i++], out);
        }
    }

    @Override
    public Object readResponse(Schema schema, Decoder in) throws IOException {
        return this.getDatumReader(schema).read(null, in);
    }

    @Override
    public Exception readError(Schema schema, Decoder in) throws IOException {
        Object value = this.getDatumReader(schema).read(null, in);
        if (value instanceof Exception) {
            return (Exception)value;
        }
        return new AvroRuntimeException(value.toString());
    }

    public static <T> T getClient(Class<T> iface, Transceiver transciever) throws IOException {
        return SpecificRequestor.getClient(iface, transciever, SpecificData.get());
    }

    public static <T> T getClient(Class<T> iface, Transceiver transciever, SpecificData specificData) throws IOException {
        Protocol protocol = specificData.getProtocol(iface);
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new SpecificRequestor(protocol, transciever));
    }

    public static <T> T getClient(Class<T> iface, SpecificRequestor requestor) throws IOException {
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)requestor);
    }

    public static Protocol getRemote(Object proxy) throws IOException {
        return ((Requestor)((Object)Proxy.getInvocationHandler(proxy))).getRemote();
    }
}

