/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import java.util.Iterator;
import org.apache.avro.mapred.AvroCollector;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroReducer;
import org.apache.avro.mapred.AvroValue;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;

abstract class HadoopReducerBase<K, V, OUT, KO, VO>
extends MapReduceBase
implements Reducer<AvroKey<K>, AvroValue<V>, KO, VO> {
    private AvroReducer<K, V, OUT> reducer;
    private AvroCollector<OUT> collector;
    private ReduceIterable reduceIterable = new ReduceIterable();

    HadoopReducerBase() {
    }

    protected abstract AvroReducer<K, V, OUT> getReducer(JobConf var1);

    protected abstract AvroCollector<OUT> getCollector(OutputCollector<KO, VO> var1);

    @Override
    public void configure(JobConf conf) {
        this.reducer = this.getReducer(conf);
    }

    @Override
    public final void reduce(AvroKey<K> key, Iterator<AvroValue<V>> values, OutputCollector<KO, VO> out, Reporter reporter) throws IOException {
        if (this.collector == null) {
            this.collector = this.getCollector(out);
        }
        this.reduceIterable.values = values;
        this.reducer.reduce(key.datum(), this.reduceIterable, this.collector, reporter);
    }

    class ReduceIterable
    implements Iterable<V>,
    Iterator<V> {
        private Iterator<AvroValue<V>> values;

        ReduceIterable() {
        }

        @Override
        public boolean hasNext() {
            return this.values.hasNext();
        }

        @Override
        public V next() {
            return this.values.next().datum();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }
    }
}

