/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.tool.Tool;

public class JsonToBinaryFragmentTool
implements Tool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        boolean needsClosing;
        InputStream input;
        if (args.size() != 2) {
            err.println("Expected 2 arguments: schema json_data_file");
            err.println("Use '-' as json_data_file for stdin.");
            return 1;
        }
        Schema schema = Schema.parse(args.get(0));
        if (args.get(1).equals("-")) {
            input = stdin;
            needsClosing = false;
        } else {
            input = new FileInputStream(args.get(1));
            needsClosing = true;
        }
        try {
            GenericDatumReader<Object> reader = new GenericDatumReader<Object>(schema);
            Object datum = reader.read(null, DecoderFactory.get().jsonDecoder(schema, input));
            GenericDatumWriter<Object> writer = new GenericDatumWriter<Object>(schema);
            BinaryEncoder e = EncoderFactory.get().binaryEncoder(out, null);
            writer.write(datum, e);
            e.flush();
        }
        finally {
            if (needsClosing) {
                input.close();
            }
        }
        return 0;
    }

    @Override
    public String getName() {
        return "jsontofrag";
    }

    @Override
    public String getShortDescription() {
        return "Renders a JSON-encoded Avro datum as binary.";
    }
}

