/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.TestProtocolSpecific;
import org.apache.avro.generic.GenericData;
import org.apache.avro.ipc.HttpServer;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.test.Simple;
import org.junit.Test;

public class TestProtocolHttp
extends TestProtocolSpecific {
    @Override
    public Server createServer(Responder testResponder) throws Exception {
        return new HttpServer(testResponder, 0);
    }

    @Override
    public Transceiver createTransceiver() throws Exception {
        return new HttpTransceiver(new URL("http://127.0.0.1:" + server.getPort() + "/"));
    }

    @Override
    protected int getExpectedHandshakeCount() {
        return -1;
    }

    @Test(expected=SocketTimeoutException.class)
    public void testTimeout() throws Throwable {
        ServerSocket s = new ServerSocket(0);
        HttpTransceiver client = new HttpTransceiver(new URL("http://127.0.0.1:" + s.getLocalPort() + "/"));
        client.setTimeout(100);
        Simple proxy = SpecificRequestor.getClient(Simple.class, client);
        try {
            proxy.hello("foo");
        }
        catch (AvroRemoteException e) {
            throw e.getCause();
        }
        finally {
            s.close();
        }
    }

    @Test
    public void testStatelessOneway() throws Exception {
        Protocol protocol = new Protocol("Simple", "org.apache.avro.test");
        Protocol.Message message = protocol.createMessage("ack", null, Schema.createRecord(new ArrayList<Schema.Field>()), Schema.create(Schema.Type.NULL), Schema.createUnion(new ArrayList<Schema>()));
        protocol.getMessages().put("ack", message);
        GenericRequestor requestor = new GenericRequestor(protocol, this.createTransceiver());
        requestor.request("ack", new GenericData.Record(message.getRequest()));
        requestor.request("ack", new GenericData.Record(message.getRequest()));
    }
}

