/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Random;
import javax.servlet.UnavailableException;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.Protocol;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.ipc.HttpServer;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.LocalTransceiver;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.ipc.generic.GenericResponder;
import org.apache.avro.ipc.stats.FakeTicks;
import org.apache.avro.ipc.stats.StatsPlugin;
import org.apache.avro.ipc.stats.StatsServer;
import org.apache.avro.ipc.stats.StatsServlet;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.log.Log;

public class TestStatsPluginAndServlet {
    Protocol protocol = Protocol.parse("{\"protocol\": \"Minimal\", \"messages\": { \"m\": {   \"request\": [{\"name\": \"x\", \"type\": \"int\"}],    \"response\": \"int\"} } }");
    Protocol.Message message = this.protocol.getMessages().get("m");
    private static final long MS = 1000000L;

    private String generateServletResponse(StatsPlugin statsPlugin) throws IOException {
        StatsServlet servlet;
        try {
            servlet = new StatsServlet(statsPlugin);
        }
        catch (UnavailableException e1) {
            throw new IOException();
        }
        StringWriter w = new StringWriter();
        try {
            servlet.writeStats(w);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String o = w.toString();
        return o;
    }

    private void makeRequest(Transceiver t) throws IOException {
        GenericData.Record params = new GenericData.Record(this.protocol.getMessages().get("m").getRequest());
        params.put("x", (Object)0);
        GenericRequestor r = new GenericRequestor(this.protocol, t);
        Assert.assertEquals((Object)1, (Object)r.request("m", params));
    }

    @Test
    public void testFullServerPath() throws IOException {
        TestResponder r = new TestResponder(this.protocol);
        StatsPlugin statsPlugin = new StatsPlugin();
        r.addRPCPlugin(statsPlugin);
        LocalTransceiver t = new LocalTransceiver(r);
        for (int i = 0; i < 10; ++i) {
            this.makeRequest(t);
        }
        String o = this.generateServletResponse(statsPlugin);
        Assert.assertTrue((boolean)o.contains("10 calls"));
    }

    @Test
    public void testMultipleRPCs() throws IOException {
        FakeTicks t = new FakeTicks();
        StatsPlugin statsPlugin = new StatsPlugin(t, StatsPlugin.LATENCY_SEGMENTER, StatsPlugin.PAYLOAD_SEGMENTER);
        RPCContext context1 = this.makeContext();
        RPCContext context2 = this.makeContext();
        statsPlugin.serverReceiveRequest(context1);
        t.passTime(100000000L);
        statsPlugin.serverReceiveRequest(context2);
        String r = this.generateServletResponse(statsPlugin);
        Assert.assertTrue((boolean)r.contains("m: 0ms"));
        Assert.assertTrue((boolean)r.contains("m: 100ms"));
        statsPlugin.serverSendResponse(context1);
        t.passTime(900000000L);
        statsPlugin.serverSendResponse(context2);
        r = this.generateServletResponse(statsPlugin);
        Assert.assertTrue((boolean)r.contains("Average: 500.0ms"));
    }

    @Test
    public void testPayloadSize() throws IOException {
        TestResponder r = new TestResponder(this.protocol);
        StatsPlugin statsPlugin = new StatsPlugin();
        r.addRPCPlugin(statsPlugin);
        LocalTransceiver t = new LocalTransceiver(r);
        this.makeRequest(t);
        String resp = this.generateServletResponse(statsPlugin);
        Assert.assertTrue((boolean)resp.contains("Average: 2.0"));
    }

    private RPCContext makeContext() {
        RPCContext context = new RPCContext();
        context.setMessage(this.message);
        return context;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            args = new String[]{"7002", "7003"};
        }
        Protocol protocol = Protocol.parse("{\"protocol\": \"sleepy\", \"messages\": { \"sleep\": {   \"request\": [{\"name\": \"millis\", \"type\": \"long\"},{\"name\": \"data\", \"type\": \"bytes\"}],    \"response\": \"null\"} } }");
        Log.info("Using protocol: " + protocol.toString());
        SleepyResponder r = new SleepyResponder(protocol);
        StatsPlugin p = new StatsPlugin();
        r.addRPCPlugin(p);
        HttpServer avroServer = new HttpServer((Responder)r, Integer.parseInt(args[0]));
        avroServer.start();
        StatsServer ss = new StatsServer(p, 8080);
        HttpTransceiver trans = new HttpTransceiver(new URL("http://localhost:" + Integer.parseInt(args[0])));
        GenericRequestor req = new GenericRequestor(protocol, trans);
        while (true) {
            Thread.sleep(1000L);
            GenericData.Record params = new GenericData.Record(protocol.getMessages().get("sleep").getRequest());
            Random rand = new Random();
            params.put("millis", (Object)(Math.abs(rand.nextLong()) % 1000L));
            int payloadSize = Math.abs(rand.nextInt()) % 10000;
            byte[] payload = new byte[payloadSize];
            rand.nextBytes(payload);
            params.put("data", (Object)ByteBuffer.wrap(payload));
            req.request("sleep", params);
        }
    }

    private static class SleepyResponder
    extends GenericResponder {
        public SleepyResponder(Protocol local) {
            super(local);
        }

        @Override
        public Object respond(Protocol.Message message, Object request) throws AvroRemoteException {
            try {
                Thread.sleep((Long)((GenericRecord)request).get("millis"));
            }
            catch (InterruptedException e) {
                throw new AvroRemoteException(e);
            }
            return null;
        }
    }

    static class TestResponder
    extends GenericResponder {
        public TestResponder(Protocol local) {
            super(local);
        }

        @Override
        public Object respond(Protocol.Message message, Object request) throws AvroRemoteException {
            Assert.assertEquals((Object)0, (Object)((GenericRecord)request).get("x"));
            return 1;
        }
    }
}

