/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.ipc.Ipc;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

public class RpcSendTool
implements Tool {
    @Override
    public String getName() {
        return "rpcsend";
    }

    @Override
    public String getShortDescription() {
        return "Sends a single RPC message.";
    }

    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        Object datum;
        OptionParser p = new OptionParser();
        ArgumentAcceptingOptionSpec<String> file = p.accepts("file", "Data file containing request parameters.").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> data = p.accepts("data", "JSON-encoded request parameters.").withRequiredArg().ofType(String.class);
        OptionSet opts = p.parse(args.toArray(new String[0]));
        if ((args = opts.nonOptionArguments()).size() != 3) {
            err.println("Usage: uri protocol_file message_name (-data d | -file f)");
            p.printHelpOn(err);
            return 1;
        }
        URI uri = new URI(args.get(0));
        Protocol protocol = Protocol.parse(new File(args.get(1)));
        String messageName = args.get(2);
        Protocol.Message message = protocol.getMessages().get(messageName);
        if (message == null) {
            err.println(String.format("No message named '%s' found in protocol '%s'.", messageName, protocol));
            return 1;
        }
        if (data.value(opts) != null) {
            datum = Util.jsonToGenericDatum(message.getRequest(), (String)data.value(opts));
        } else if (file.value(opts) != null) {
            datum = Util.datumFromFile(message.getRequest(), (String)file.value(opts));
        } else {
            err.println("One of -data or -file must be specified.");
            return 1;
        }
        GenericRequestor client = new GenericRequestor(protocol, Ipc.createTransceiver(uri));
        Object response = client.request(message.getName(), datum);
        this.dumpJson(out, message.getResponse(), response);
        return 0;
    }

    private void dumpJson(PrintStream out, Schema schema, Object datum) throws IOException {
        GenericDatumWriter<Object> writer = new GenericDatumWriter<Object>(schema);
        JsonGenerator g = new JsonFactory().createJsonGenerator(out, JsonEncoding.UTF8);
        g.useDefaultPrettyPrinter();
        writer.write(datum, EncoderFactory.get().jsonEncoder(schema, g));
        g.flush();
        out.println();
        out.flush();
    }
}

