/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NamenodeFsck;
import org.apache.hadoop.security.UserGroupInformation;

public class FsckServlet
extends DfsServlet {
    private static final long serialVersionUID = 1L;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        final Map pmap = request.getParameterMap();
        final PrintWriter out = response.getWriter();
        final InetAddress remoteAddress = InetAddress.getByName(request.getRemoteAddr());
        final ServletContext context = this.getServletContext();
        final Configuration conf = (Configuration)context.getAttribute("current.conf");
        UserGroupInformation ugi = this.getUGI(request, conf);
        try {
            ugi.doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    NameNode nn = (NameNode)context.getAttribute("name.node");
                    int totalDatanodes = nn.namesystem.getNumberOfDatanodes(FSConstants.DatanodeReportType.LIVE);
                    short minReplication = nn.namesystem.getMinReplication();
                    new NamenodeFsck(conf, nn, nn.getNetworkTopology(), pmap, out, totalDatanodes, minReplication, remoteAddress).fsck();
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            response.sendError(400, e.getMessage());
        }
    }
}

