/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.util.Shell;

public class ShellBasedUnixGroupsNetgroupMapping
extends ShellBasedUnixGroupsMapping {
    private static final Log LOG = LogFactory.getLog(ShellBasedUnixGroupsNetgroupMapping.class);
    protected static boolean netgroupToUsersMapUpdated = true;
    protected static Map<String, Set<String>> netgroupToUsersMap = new ConcurrentHashMap<String, Set<String>>();
    protected static Map<String, Set<String>> userToNetgroupsMap = new ConcurrentHashMap<String, Set<String>>();

    @Override
    public List<String> getGroups(String user) throws IOException {
        LinkedList<String> groups = new LinkedList<String>();
        this.getUnixGroups(user, groups);
        this.getNetgroups(user, groups);
        return groups;
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
        LinkedList<String> groups = new LinkedList<String>(netgroupToUsersMap.keySet());
        netgroupToUsersMap.clear();
        this.cacheGroupsAdd(groups);
        netgroupToUsersMapUpdated = true;
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
        for (String group : groups) {
            if (group.length() == 0 || group.charAt(0) != '@') continue;
            this.cacheNetgroup(group);
        }
    }

    protected void cacheNetgroup(String group) throws IOException {
        String[] userInfos;
        if (netgroupToUsersMap.containsKey(group)) {
            return;
        }
        String usersRaw = this.execShellGetUserForNetgroup(group);
        usersRaw = usersRaw.replaceAll(" +", "");
        usersRaw = usersRaw.replaceFirst(group.replaceFirst("@", "") + "[()]+", "");
        for (String userInfo : userInfos = usersRaw.split("[()]+")) {
            String user = userInfo.replaceFirst("[^,]*,", "");
            user = user.replaceFirst(",.*$", "");
            if (!netgroupToUsersMap.containsKey(group)) {
                netgroupToUsersMap.put(group, new HashSet());
            }
            netgroupToUsersMap.get(group).add(user);
        }
        netgroupToUsersMapUpdated = true;
    }

    private void getUnixGroups(String user, List<String> groups) throws IOException {
        String result = this.execShellGetUnixGroups(user);
        StringTokenizer tokenizer = new StringTokenizer(result);
        while (tokenizer.hasMoreTokens()) {
            groups.add(tokenizer.nextToken());
        }
    }

    protected void getNetgroups(String user, List<String> groups) throws IOException {
        if (netgroupToUsersMapUpdated) {
            netgroupToUsersMapUpdated = false;
            for (String netgroup : netgroupToUsersMap.keySet()) {
                for (String netuser : netgroupToUsersMap.get(netgroup)) {
                    if (!userToNetgroupsMap.containsKey(netuser)) {
                        userToNetgroupsMap.put(netuser, new HashSet());
                    }
                    userToNetgroupsMap.get(netuser).add(netgroup);
                }
            }
        }
        if (userToNetgroupsMap.containsKey(user)) {
            for (String netgroup : userToNetgroupsMap.get(user)) {
                groups.add(netgroup);
            }
        }
    }

    protected String execShellGetUnixGroups(String user) throws IOException {
        String result = "";
        try {
            result = Shell.execCommand(Shell.getGroupsForUserCommand(user));
        }
        catch (Shell.ExitCodeException e) {
            LOG.warn("error while getting groups for user " + user, e);
        }
        return result;
    }

    protected String execShellGetUserForNetgroup(String netgroup) throws IOException {
        String result = "";
        try {
            result = Shell.execCommand(Shell.getUsersForNetgroupCommand(netgroup.substring(1)));
        }
        catch (Shell.ExitCodeException e) {
            LOG.warn("error while getting users for netgroup " + netgroup, e);
        }
        return result;
    }
}

