/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import org.apache.trevni.ArrayColumnOutputBuffer;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.ColumnOutputBuffer;
import org.apache.trevni.OutputBuffer;
import org.apache.trevni.TrevniRuntimeException;

public class ColumnFileWriter {
    static final byte[] MAGIC_0 = new byte[]{84, 114, 118, 0};
    static final byte[] MAGIC_1 = new byte[]{84, 114, 118, 1};
    static final byte[] MAGIC = new byte[]{84, 114, 118, 2};
    private ColumnFileMetaData metaData;
    private ColumnOutputBuffer[] columns;
    private long rowCount;
    private int columnCount;
    private long size;

    public ColumnFileWriter(ColumnFileMetaData fileMeta, ColumnMetaData ... columnMeta) throws IOException {
        this.checkColumns(columnMeta);
        this.metaData = fileMeta;
        this.columnCount = columnMeta.length;
        this.columns = new ColumnOutputBuffer[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnMetaData c = columnMeta[i];
            c.setDefaults(this.metaData);
            this.columns[i] = c.isArray() ? new ArrayColumnOutputBuffer(this, c) : new ColumnOutputBuffer(this, c);
            this.size += 65536L;
        }
    }

    private void checkColumns(ColumnMetaData[] columnMeta) {
        HashSet<String> seen = new HashSet<String>();
        for (int i = 0; i < columnMeta.length; ++i) {
            ColumnMetaData c = columnMeta[i];
            String name = c.getName();
            if (seen.contains(name)) {
                throw new TrevniRuntimeException("Duplicate column name: " + name);
            }
            ColumnMetaData parent = c.getParent();
            if (parent != null && !seen.contains(parent.getName())) {
                throw new TrevniRuntimeException("Parent must precede child: " + name);
            }
            seen.add(name);
        }
    }

    void incrementSize(int n) {
        this.size += (long)n;
    }

    public long sizeEstimate() {
        return this.size;
    }

    public ColumnFileMetaData getMetaData() {
        return this.metaData;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void writeRow(Object ... row) throws IOException {
        this.startRow();
        for (int column = 0; column < this.columnCount; ++column) {
            this.writeValue(row[column], column);
        }
        this.endRow();
    }

    public void startRow() throws IOException {
        for (int column = 0; column < this.columnCount; ++column) {
            this.columns[column].startRow();
        }
    }

    public void writeLength(int length, int column) throws IOException {
        this.columns[column].writeLength(length);
    }

    public void writeValue(Object value, int column) throws IOException {
        this.columns[column].writeValue(value);
    }

    public void endRow() throws IOException {
        for (int column = 0; column < this.columnCount; ++column) {
            this.columns[column].endRow();
        }
        ++this.rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            this.writeTo(out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        this.writeHeader(out);
        for (int column = 0; column < this.columnCount; ++column) {
            this.columns[column].writeTo(out);
        }
    }

    private void writeHeader(OutputStream out) throws IOException {
        OutputBuffer header = new OutputBuffer();
        header.write(MAGIC);
        header.writeFixed64(this.rowCount);
        header.writeFixed32(this.columnCount);
        this.metaData.write(header);
        for (ColumnOutputBuffer column : this.columns) {
            column.getMeta().write(header);
        }
        for (long start : this.computeStarts(header.size())) {
            header.writeFixed64(start);
        }
        header.writeTo(out);
    }

    private long[] computeStarts(long start) throws IOException {
        long[] result = new long[this.columnCount];
        start += (long)(this.columnCount * 8);
        for (int column = 0; column < this.columnCount; ++column) {
            result[column] = start;
            start += this.columns[column].size();
        }
        return result;
    }
}

