/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.ValueType;
import org.apache.trevni.avro.AvroColumnReader;
import org.apache.trevni.avro.AvroColumnWriter;
import org.apache.trevni.avro.AvroColumnator;
import org.apache.trevni.avro.RandomData;
import org.junit.Assert;
import org.junit.Test;

public class TestShredder {
    private static final int COUNT = 100;
    private static final File FILE = new File("target", "test.trv");
    private static final String SIMPLE_FIELDS = "{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":\"string\"}";
    private static final String SIMPLE_RECORD = "{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":\"string\"}]}";
    private static final String RECORD_ARRAY = "{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":\"string\"}]}}";
    private static final String UNION = "[\"null\",\"int\",{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":\"string\"}]}]";

    @Test
    public void testPrimitives() throws Exception {
        this.check(Schema.create(Schema.Type.NULL), new ColumnMetaData("null", ValueType.NULL));
        this.check(Schema.create(Schema.Type.BOOLEAN), new ColumnMetaData("boolean", ValueType.BOOLEAN));
        this.check(Schema.create(Schema.Type.INT), new ColumnMetaData("int", ValueType.INT));
        this.check(Schema.create(Schema.Type.LONG), new ColumnMetaData("long", ValueType.LONG));
        this.check(Schema.create(Schema.Type.FLOAT), new ColumnMetaData("float", ValueType.FLOAT));
        this.check(Schema.create(Schema.Type.DOUBLE), new ColumnMetaData("double", ValueType.DOUBLE));
        this.check(Schema.create(Schema.Type.BYTES), new ColumnMetaData("bytes", ValueType.BYTES));
        this.check(Schema.create(Schema.Type.STRING), new ColumnMetaData("string", ValueType.STRING));
        this.check(Schema.createEnum("E", null, null, Arrays.asList("X", "Y", "Z")), new ColumnMetaData("E", ValueType.INT));
        this.check(Schema.createFixed("F", null, null, 5), new ColumnMetaData("F", ValueType.BYTES));
    }

    @Test
    public void testSimpleRecord() throws Exception {
        this.check(Schema.parse(SIMPLE_RECORD), new ColumnMetaData("x", ValueType.INT), new ColumnMetaData("y", ValueType.STRING));
    }

    @Test
    public void testDefaultValue() throws Exception {
        String s = "{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":\"string\"},{\"name\":\"z\",\"type\":\"int\",\"default\":1,\"use-default\":true}]}";
        this.checkWrite(Schema.parse(SIMPLE_RECORD));
        this.checkRead(Schema.parse(s));
    }

    @Test
    public void testNestedRecord() throws Exception {
        String s = "{\"type\":\"record\",\"name\":\"S\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"R\",\"type\":{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":\"string\"}]}},{\"name\":\"y\",\"type\":\"string\"}]}";
        this.check(Schema.parse(s), new ColumnMetaData("x", ValueType.INT), new ColumnMetaData("R#x", ValueType.INT), new ColumnMetaData("R#y", ValueType.STRING), new ColumnMetaData("y", ValueType.STRING));
    }

    @Test
    public void testNamedRecord() throws Exception {
        String s = "{\"type\":\"record\",\"name\":\"S\",\"fields\":[{\"name\":\"R1\",\"type\":{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":\"string\"}]}},{\"name\":\"R2\",\"type\":\"R\"}]}";
        this.check(Schema.parse(s), new ColumnMetaData("R1#x", ValueType.INT), new ColumnMetaData("R1#y", ValueType.STRING), new ColumnMetaData("R2#x", ValueType.INT), new ColumnMetaData("R2#y", ValueType.STRING));
    }

    @Test
    public void testSimpleArray() throws Exception {
        String s = "{\"type\":\"array\",\"items\":\"long\"}";
        this.check(Schema.parse(s), new ColumnMetaData("[]", ValueType.LONG).isArray(true));
    }

    @Test
    public void testArray() throws Exception {
        ColumnMetaData p = new ColumnMetaData("[]", ValueType.NULL).isArray(true);
        this.check(Schema.parse(RECORD_ARRAY), p, new ColumnMetaData("[]#x", ValueType.INT).setParent(p), new ColumnMetaData("[]#y", ValueType.STRING).setParent(p));
    }

    @Test
    public void testSimpleUnion() throws Exception {
        String s = "[\"int\",\"string\"]";
        this.check(Schema.parse(s), new ColumnMetaData("int", ValueType.INT).isArray(true), new ColumnMetaData("string", ValueType.STRING).isArray(true));
    }

    @Test
    public void testSimpleOptional() throws Exception {
        String s = "[\"null\",\"string\"]";
        this.check(Schema.parse(s), new ColumnMetaData("string", ValueType.STRING).isArray(true));
    }

    @Test
    public void testUnion() throws Exception {
        ColumnMetaData p = new ColumnMetaData("R", ValueType.NULL).isArray(true);
        this.check(Schema.parse(UNION), new ColumnMetaData("int", ValueType.INT).isArray(true), p, new ColumnMetaData("R#x", ValueType.INT).setParent(p), new ColumnMetaData("R#y", ValueType.STRING).setParent(p));
    }

    @Test
    public void testNestedArray() throws Exception {
        String s = "{\"type\":\"record\",\"name\":\"S\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"A\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":\"string\"}]}}},{\"name\":\"y\",\"type\":\"string\"}]}";
        ColumnMetaData p = new ColumnMetaData("A[]", ValueType.NULL).isArray(true);
        this.check(Schema.parse(s), new ColumnMetaData("x", ValueType.INT), p, new ColumnMetaData("A[]#x", ValueType.INT).setParent(p), new ColumnMetaData("A[]#y", ValueType.STRING).setParent(p), new ColumnMetaData("y", ValueType.STRING));
    }

    @Test
    public void testNestedUnion() throws Exception {
        String s = "{\"type\":\"record\",\"name\":\"S\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"u\",\"type\":[\"null\",\"int\",{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":\"string\"}]}]},{\"name\":\"y\",\"type\":\"string\"}]}";
        ColumnMetaData p = new ColumnMetaData("u/R", ValueType.NULL).isArray(true);
        this.check(Schema.parse(s), new ColumnMetaData("x", ValueType.INT), new ColumnMetaData("u/int", ValueType.INT).isArray(true), p, new ColumnMetaData("u/R#x", ValueType.INT).setParent(p), new ColumnMetaData("u/R#y", ValueType.STRING).setParent(p), new ColumnMetaData("y", ValueType.STRING));
    }

    @Test
    public void testUnionInArray() throws Exception {
        String s = "{\"type\":\"record\",\"name\":\"S\",\"fields\":[{\"name\":\"a\",\"type\":{\"type\":\"array\",\"items\":[\"null\",\"int\",{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":\"string\"}]}]}}]}";
        ColumnMetaData p = new ColumnMetaData("a[]", ValueType.NULL).isArray(true);
        ColumnMetaData r = new ColumnMetaData("a[]/R", ValueType.NULL).setParent(p).isArray(true);
        this.check(Schema.parse(s), p, new ColumnMetaData("a[]/int", ValueType.INT).setParent(p).isArray(true), r, new ColumnMetaData("a[]/R#x", ValueType.INT).setParent(r), new ColumnMetaData("a[]/R#y", ValueType.STRING).setParent(r));
    }

    @Test
    public void testArrayInUnion() throws Exception {
        String s = "{\"type\":\"record\",\"name\":\"S\",\"fields\":[{\"name\":\"a\",\"type\":[\"int\",{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":\"string\"}]}}]}]}";
        ColumnMetaData q = new ColumnMetaData("a/array", ValueType.NULL).isArray(true);
        ColumnMetaData r = new ColumnMetaData("a/array[]", ValueType.NULL).setParent(q).isArray(true);
        this.check(Schema.parse(s), new ColumnMetaData("a/int", ValueType.INT).isArray(true), q, r, new ColumnMetaData("a/array[]#x", ValueType.INT).setParent(r), new ColumnMetaData("a/array[]#y", ValueType.STRING).setParent(r));
    }

    @Test
    public void testSimpleMap() throws Exception {
        String s = "{\"type\":\"map\",\"values\":\"long\"}";
        ColumnMetaData p = new ColumnMetaData(">", ValueType.NULL).isArray(true);
        this.check(Schema.parse(s), p, new ColumnMetaData(">key", ValueType.STRING).setParent(p), new ColumnMetaData(">value", ValueType.LONG).setParent(p));
    }

    @Test
    public void testMap() throws Exception {
        String s = "{\"type\":\"map\",\"values\":{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":\"string\"}]}}";
        ColumnMetaData p = new ColumnMetaData(">", ValueType.NULL).isArray(true);
        this.check(Schema.parse(s), p, new ColumnMetaData(">key", ValueType.STRING).setParent(p), new ColumnMetaData(">value#x", ValueType.INT).setParent(p), new ColumnMetaData(">value#y", ValueType.STRING).setParent(p));
    }

    private void check(Schema s, ColumnMetaData ... expected) throws Exception {
        ColumnMetaData[] shredded = new AvroColumnator(s).getColumns();
        Assert.assertEquals((long)expected.length, (long)shredded.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i].toString(), (Object)shredded[i].toString());
        }
        this.checkWrite(s);
        this.checkRead(s);
    }

    private void checkWrite(Schema schema) throws IOException {
        AvroColumnWriter<Object> writer = new AvroColumnWriter<Object>(schema, new ColumnFileMetaData());
        boolean count = false;
        for (Object datum : new RandomData(schema, 100)) {
            writer.write(datum);
        }
        writer.writeTo(FILE);
    }

    private void checkRead(Schema schema) throws IOException {
        AvroColumnReader reader = new AvroColumnReader(new AvroColumnReader.Params(FILE).setSchema(schema));
        for (Object expected : new RandomData(schema, 100)) {
            Assert.assertEquals((Object)expected, reader.next());
        }
        reader.close();
    }
}

