/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.direct.DirectGraph;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ListMultimap;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.AppliedPTransform;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;

class DirectGraphVisitor
extends Pipeline.PipelineVisitor.Defaults {
    private Map<POutput, AppliedPTransform<?, ?, ?>> producers = new HashMap();
    private ListMultimap<PInput, AppliedPTransform<?, ?, ?>> primitiveConsumers = ArrayListMultimap.create();
    private Set<PCollectionView<?>> views = new HashSet();
    private Set<AppliedPTransform<?, ?, ?>> rootTransforms = new HashSet();
    private Map<AppliedPTransform<?, ?, ?>, String> stepNames = new HashMap();
    private Set<PValue> toFinalize = new HashSet<PValue>();
    private int numTransforms = 0;
    private boolean finalized = false;

    DirectGraphVisitor() {
    }

    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        Preconditions.checkState(!this.finalized, "Attempting to traverse a pipeline (node %s) with a %s which has already visited a Pipeline and is finalized", node.getFullName(), ((Object)((Object)this)).getClass().getSimpleName());
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(TransformHierarchy.Node node) {
        Preconditions.checkState(!this.finalized, "Attempting to traverse a pipeline (node %s) with a %s which is already finalized", node.getFullName(), ((Object)((Object)this)).getClass().getSimpleName());
        if (node.isRootNode()) {
            this.finalized = true;
        }
    }

    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        this.toFinalize.removeAll(node.getInputs());
        AppliedPTransform<?, ?, ?> appliedTransform = this.getAppliedTransform(node);
        this.stepNames.put(appliedTransform, this.genStepName());
        if (node.getInputs().isEmpty()) {
            this.rootTransforms.add(appliedTransform);
        } else {
            for (PValue value : node.getInputs()) {
                this.primitiveConsumers.put((PInput)value, appliedTransform);
            }
        }
    }

    public void visitValue(PValue value, TransformHierarchy.Node producer) {
        this.toFinalize.add(value);
        AppliedPTransform<?, ?, ?> appliedTransform = this.getAppliedTransform(producer);
        if (!this.producers.containsKey(value)) {
            this.producers.put((POutput)value, appliedTransform);
        }
        if (value instanceof PCollectionView) {
            this.views.add((PCollectionView)value);
        }
        if (!this.producers.containsKey(value)) {
            this.producers.put((POutput)value, appliedTransform);
        }
    }

    private AppliedPTransform<?, ?, ?> getAppliedTransform(TransformHierarchy.Node node) {
        AppliedPTransform application = node.toAppliedPTransform();
        return application;
    }

    private String genStepName() {
        return String.format("s%s", this.numTransforms++);
    }

    public void finishSpecifyingRemainder() {
        Preconditions.checkState(this.finalized, "Can't call finishSpecifyingRemainder before the Pipeline has been completely traversed");
        for (PValue unfinalized : this.toFinalize) {
            unfinalized.finishSpecifying();
        }
    }

    public DirectGraph getGraph() {
        Preconditions.checkState(this.finalized, "Can't get a graph before the Pipeline has been completely traversed");
        return DirectGraph.create(this.producers, this.primitiveConsumers, this.views, this.rootTransforms, this.stepNames);
    }
}

