/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.KeyedWorkItemCoder;
import org.apache.beam.runners.direct.ForwardingPTransform;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

class DirectGroupByKey<K, V>
extends ForwardingPTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
    private final GroupByKey<K, V> original;

    DirectGroupByKey(GroupByKey<K, V> from) {
        this.original = from;
    }

    @Override
    public PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> delegate() {
        return this.original;
    }

    @Override
    public PCollection<KV<K, Iterable<V>>> expand(PCollection<KV<K, V>> input) {
        KvCoder inputCoder = (KvCoder)input.getCoder();
        WindowingStrategy inputWindowingStrategy = input.getWindowingStrategy();
        WindowingStrategy outputWindowingStrategy = this.original.updateWindowingStrategy(inputWindowingStrategy);
        return ((PCollection)((PCollection)input.apply(new DirectGroupByKeyOnly())).setCoder((Coder)KeyedWorkItemCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)inputCoder.getValueCoder(), (Coder)inputWindowingStrategy.getWindowFn().windowCoder())).apply("GroupAlsoByWindow", new DirectGroupAlsoByWindow(inputWindowingStrategy, outputWindowingStrategy))).setCoder((Coder)KvCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)IterableCoder.of((Coder)inputCoder.getValueCoder())));
    }

    static final class DirectGroupAlsoByWindow<K, V>
    extends PTransform<PCollection<KeyedWorkItem<K, V>>, PCollection<KV<K, Iterable<V>>>> {
        private final WindowingStrategy<?, ?> inputWindowingStrategy;
        private final WindowingStrategy<?, ?> outputWindowingStrategy;

        public DirectGroupAlsoByWindow(WindowingStrategy<?, ?> inputWindowingStrategy, WindowingStrategy<?, ?> outputWindowingStrategy) {
            this.inputWindowingStrategy = inputWindowingStrategy;
            this.outputWindowingStrategy = outputWindowingStrategy;
        }

        public WindowingStrategy<?, ?> getInputWindowingStrategy() {
            return this.inputWindowingStrategy;
        }

        private KeyedWorkItemCoder<K, V> getKeyedWorkItemCoder(Coder<KeyedWorkItem<K, V>> inputCoder) {
            Preconditions.checkArgument(inputCoder instanceof KeyedWorkItemCoder, "%s requires a %s<...> but got %s", ((Object)((Object)this)).getClass().getSimpleName(), KvCoder.class.getSimpleName(), inputCoder);
            KeyedWorkItemCoder kvCoder = (KeyedWorkItemCoder)inputCoder;
            return kvCoder;
        }

        public Coder<K> getKeyCoder(Coder<KeyedWorkItem<K, V>> inputCoder) {
            return this.getKeyedWorkItemCoder(inputCoder).getKeyCoder();
        }

        public Coder<V> getValueCoder(Coder<KeyedWorkItem<K, V>> inputCoder) {
            return this.getKeyedWorkItemCoder(inputCoder).getElementCoder();
        }

        public PCollection<KV<K, Iterable<V>>> expand(PCollection<KeyedWorkItem<K, V>> input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), this.outputWindowingStrategy, (PCollection.IsBounded)input.isBounded());
        }
    }

    static final class DirectGroupByKeyOnly<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KeyedWorkItem<K, V>>> {
        public PCollection<KeyedWorkItem<K, V>> expand(PCollection<KV<K, V>> input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)input.isBounded());
        }

        DirectGroupByKeyOnly() {
        }
    }
}

