/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import javax.annotation.Nullable;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.sdk.util.TimeDomain;
import org.apache.beam.sdk.util.TimerInternals;
import org.apache.beam.sdk.util.state.StateNamespace;
import org.joda.time.Instant;

class DirectTimerInternals
implements TimerInternals {
    private final Clock processingTimeClock;
    private final WatermarkManager.TransformWatermarks watermarks;
    private final WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder;

    public static DirectTimerInternals create(Clock clock, WatermarkManager.TransformWatermarks watermarks, WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        return new DirectTimerInternals(clock, watermarks, timerUpdateBuilder);
    }

    private DirectTimerInternals(Clock clock, WatermarkManager.TransformWatermarks watermarks, WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        this.processingTimeClock = clock;
        this.watermarks = watermarks;
        this.timerUpdateBuilder = timerUpdateBuilder;
    }

    public void setTimer(StateNamespace namespace, String timerId, Instant target, TimeDomain timeDomain) {
        throw new UnsupportedOperationException("Setting timer by ID not yet supported.");
    }

    public void setTimer(TimerInternals.TimerData timerData) {
        this.timerUpdateBuilder.setTimer(timerData);
    }

    public void deleteTimer(StateNamespace namespace, String timerId) {
        throw new UnsupportedOperationException("Canceling of timer by ID is not yet supported.");
    }

    public void deleteTimer(TimerInternals.TimerData timerKey) {
        this.timerUpdateBuilder.deletedTimer(timerKey);
    }

    public WatermarkManager.TimerUpdate getTimerUpdate() {
        return this.timerUpdateBuilder.build();
    }

    public Instant currentProcessingTime() {
        return this.processingTimeClock.now();
    }

    @Nullable
    public Instant currentSynchronizedProcessingTime() {
        return this.watermarks.getSynchronizedProcessingInputTime();
    }

    public Instant currentInputWatermarkTime() {
        return this.watermarks.getInputWatermark();
    }

    @Nullable
    public Instant currentOutputWatermarkTime() {
        return this.watermarks.getOutputWatermark();
    }
}

