/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import javax.annotation.Nullable;
import org.apache.beam.runners.direct.AutoValue_ImmutableListBundleFactory_CommittedImmutableListBundle;
import org.apache.beam.runners.direct.BundleFactory;
import org.apache.beam.runners.direct.DirectRunner;
import org.apache.beam.runners.direct.StructuralKey;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ImmutableCollection;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class ImmutableListBundleFactory
implements BundleFactory {
    private static final ImmutableListBundleFactory FACTORY = new ImmutableListBundleFactory();

    public static ImmutableListBundleFactory create() {
        return FACTORY;
    }

    private ImmutableListBundleFactory() {
    }

    @Override
    public <T> DirectRunner.UncommittedBundle<T> createRootBundle() {
        return UncommittedImmutableListBundle.create(null, StructuralKey.empty());
    }

    @Override
    public <T> DirectRunner.UncommittedBundle<T> createBundle(PCollection<T> output) {
        return UncommittedImmutableListBundle.create(output, StructuralKey.empty());
    }

    @Override
    public <K, T> DirectRunner.UncommittedBundle<T> createKeyedBundle(StructuralKey<K> key, PCollection<T> output) {
        return UncommittedImmutableListBundle.create(output, key);
    }

    private static Instant minTimestamp(Iterable<? extends WindowedValue<?>> elements) {
        Instant minTs = BoundedWindow.TIMESTAMP_MAX_VALUE;
        for (WindowedValue<?> element : elements) {
            if (!element.getTimestamp().isBefore((ReadableInstant)minTs)) continue;
            minTs = element.getTimestamp();
        }
        return minTs;
    }

    static abstract class CommittedImmutableListBundle<T>
    implements DirectRunner.CommittedBundle<T> {
        CommittedImmutableListBundle() {
        }

        public static <T> CommittedImmutableListBundle<T> create(@Nullable PCollection<T> pcollection, StructuralKey<?> key, Iterable<WindowedValue<T>> committedElements, Instant minElementTimestamp, Instant synchronizedCompletionTime) {
            return new AutoValue_ImmutableListBundleFactory_CommittedImmutableListBundle<T>(pcollection, key, committedElements, minElementTimestamp, synchronizedCompletionTime);
        }

        @Override
        public DirectRunner.CommittedBundle<T> withElements(Iterable<WindowedValue<T>> elements) {
            return CommittedImmutableListBundle.create(this.getPCollection(), this.getKey(), ImmutableList.copyOf(elements), ImmutableListBundleFactory.minTimestamp(elements), this.getSynchronizedProcessingOutputWatermark());
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    private static final class UncommittedImmutableListBundle<T>
    implements DirectRunner.UncommittedBundle<T> {
        private final PCollection<T> pcollection;
        private final StructuralKey<?> key;
        private boolean committed = false;
        private ImmutableList.Builder<WindowedValue<T>> elements;
        private Instant minSoFar = BoundedWindow.TIMESTAMP_MAX_VALUE;

        public static <T> UncommittedImmutableListBundle<T> create(PCollection<T> pcollection, StructuralKey<?> key) {
            return new UncommittedImmutableListBundle<T>(pcollection, key);
        }

        private UncommittedImmutableListBundle(PCollection<T> pcollection, StructuralKey<?> key) {
            this.pcollection = pcollection;
            this.key = key;
            this.elements = ImmutableList.builder();
        }

        @Override
        public PCollection<T> getPCollection() {
            return this.pcollection;
        }

        @Override
        public UncommittedImmutableListBundle<T> add(WindowedValue<T> element) {
            Preconditions.checkState(!this.committed, "Can't add element %s to committed bundle in PCollection %s", element, this.pcollection);
            this.elements.add((Object)element);
            if (element.getTimestamp().isBefore((ReadableInstant)this.minSoFar)) {
                this.minSoFar = element.getTimestamp();
            }
            return this;
        }

        @Override
        public DirectRunner.CommittedBundle<T> commit(Instant synchronizedCompletionTime) {
            Preconditions.checkState(!this.committed, "Can't commit already committed bundle %s", this);
            this.committed = true;
            ImmutableCollection committedElements = this.elements.build();
            return CommittedImmutableListBundle.create(this.pcollection, this.key, committedElements, this.minSoFar, synchronizedCompletionTime);
        }
    }
}

