/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.HashSet;
import java.util.Set;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PValue;

class KeyedPValueTrackingVisitor
implements Pipeline.PipelineVisitor {
    private final Set<Class<? extends PTransform>> producesKeyedOutputs;
    private final Set<PValue> keyedValues;
    private boolean finalized;

    public static KeyedPValueTrackingVisitor create(Set<Class<? extends PTransform>> producesKeyedOutputs) {
        return new KeyedPValueTrackingVisitor(producesKeyedOutputs);
    }

    private KeyedPValueTrackingVisitor(Set<Class<? extends PTransform>> producesKeyedOutputs) {
        this.producesKeyedOutputs = producesKeyedOutputs;
        this.keyedValues = new HashSet<PValue>();
    }

    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        Preconditions.checkState(!this.finalized, "Attempted to use a %s that has already been finalized on a pipeline (visiting node %s)", KeyedPValueTrackingVisitor.class.getSimpleName(), node);
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(TransformHierarchy.Node node) {
        Preconditions.checkState(!this.finalized, "Attempted to use a %s that has already been finalized on a pipeline (visiting node %s)", KeyedPValueTrackingVisitor.class.getSimpleName(), node);
        if (node.isRootNode()) {
            this.finalized = true;
        } else if (this.producesKeyedOutputs.contains(node.getTransform().getClass())) {
            this.keyedValues.addAll(node.getOutputs());
        }
    }

    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
    }

    public void visitValue(PValue value, TransformHierarchy.Node producer) {
        if (this.producesKeyedOutputs.contains(producer.getTransform().getClass())) {
            this.keyedValues.add(value);
        }
    }

    public Set<PValue> getKeyedPValues() {
        Preconditions.checkState(this.finalized, "can't call getKeyedPValues before a Pipeline has been completely traversed");
        return this.keyedValues;
    }
}

