/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.List;
import org.apache.beam.runners.direct.DirectExecutionContext;
import org.apache.beam.runners.direct.DirectRunner;
import org.apache.beam.runners.direct.DoFnLifecycleManager;
import org.apache.beam.runners.direct.DoFnLifecycleManagerRemovingTransformEvaluator;
import org.apache.beam.runners.direct.DoFnLifecycleManagers;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.ParDoEvaluator;
import org.apache.beam.runners.direct.StructuralKey;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.CacheBuilder;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.CacheLoader;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.LoadingCache;
import org.apache.beam.sdk.transforms.AppliedPTransform;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ParDoEvaluatorFactory<InputT, OutputT>
implements TransformEvaluatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ParDoEvaluatorFactory.class);
    private final LoadingCache<DoFn<?, ?>, DoFnLifecycleManager> fnClones;
    private final EvaluationContext evaluationContext;

    ParDoEvaluatorFactory(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
        this.fnClones = CacheBuilder.newBuilder().build(new CacheLoader<DoFn<?, ?>, DoFnLifecycleManager>(){

            @Override
            public DoFnLifecycleManager load(DoFn<?, ?> key) throws Exception {
                return DoFnLifecycleManager.of(key);
            }
        });
    }

    public <T> TransformEvaluator<T> forApplication(AppliedPTransform<?, ?, ?> application, DirectRunner.CommittedBundle<?> inputBundle) throws Exception {
        AppliedPTransform<?, ?, ?> parDoApplication = application;
        ParDo.BoundMulti transform = (ParDo.BoundMulti)parDoApplication.getTransform();
        DoFn doFn = transform.getNewFn();
        TransformEvaluator<InputT> evaluator = this.createEvaluator(application, inputBundle.getKey(), doFn, transform.getSideInputs(), transform.getMainOutputTag(), transform.getSideOutputTags().getAll());
        return evaluator;
    }

    @Override
    public void cleanup() throws Exception {
        DoFnLifecycleManagers.removeAllFromManagers(this.fnClones.asMap().values());
    }

    TransformEvaluator<InputT> createEvaluator(AppliedPTransform<PCollection<InputT>, PCollectionTuple, ?> application, StructuralKey<?> inputBundleKey, DoFn<InputT, OutputT> doFn, List<PCollectionView<?>> sideInputs, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> sideOutputTags) throws Exception {
        String stepName = this.evaluationContext.getStepName(application);
        DirectExecutionContext.DirectStepContext stepContext = (DirectExecutionContext.DirectStepContext)this.evaluationContext.getExecutionContext(application, inputBundleKey).getOrCreateStepContext(stepName, stepName);
        DoFnLifecycleManager fnManager = this.getManagerForCloneOf(doFn);
        return DoFnLifecycleManagerRemovingTransformEvaluator.wrapping(this.createParDoEvaluator(application, sideInputs, mainOutputTag, sideOutputTags, stepContext, fnManager.get(), fnManager), fnManager);
    }

    ParDoEvaluator<InputT, OutputT> createParDoEvaluator(AppliedPTransform<PCollection<InputT>, PCollectionTuple, ?> application, List<PCollectionView<?>> sideInputs, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> sideOutputTags, DirectExecutionContext.DirectStepContext stepContext, DoFn<InputT, OutputT> fn, DoFnLifecycleManager fnManager) throws Exception {
        try {
            return ParDoEvaluator.create(this.evaluationContext, stepContext, application, ((PCollection)application.getInput()).getWindowingStrategy(), fn, sideInputs, mainOutputTag, sideOutputTags, ((PCollectionTuple)application.getOutput()).getAll());
        }
        catch (Exception e) {
            try {
                fnManager.remove();
            }
            catch (Exception removalException) {
                LOG.error("Exception encountered while cleaning up in ParDo evaluator construction", (Throwable)removalException);
                e.addSuppressed(removalException);
            }
            throw e;
        }
    }

    public DoFnLifecycleManager getManagerForCloneOf(DoFn<?, ?> fn) {
        return this.fnClones.getUnchecked(fn);
    }
}

