/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.runners.direct.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;

class ParDoSingleViaMultiOverrideFactory<InputT, OutputT>
implements PTransformOverrideFactory<PCollection<? extends InputT>, PCollection<OutputT>, ParDo.Bound<InputT, OutputT>> {
    ParDoSingleViaMultiOverrideFactory() {
    }

    @Override
    public PTransform<PCollection<? extends InputT>, PCollection<OutputT>> override(ParDo.Bound<InputT, OutputT> transform) {
        return new ParDoSingleViaMulti<InputT, OutputT>(transform);
    }

    static class ParDoSingleViaMulti<InputT, OutputT>
    extends PTransform<PCollection<? extends InputT>, PCollection<OutputT>> {
        private static final String MAIN_OUTPUT_TAG = "main";
        private final ParDo.Bound<InputT, OutputT> underlyingParDo;

        public ParDoSingleViaMulti(ParDo.Bound<InputT, OutputT> underlyingParDo) {
            this.underlyingParDo = underlyingParDo;
        }

        public PCollection<OutputT> expand(PCollection<? extends InputT> input) {
            TupleTag mainOutputTag = new TupleTag(MAIN_OUTPUT_TAG);
            PCollectionTuple outputs = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)this.underlyingParDo.getNewFn()).withSideInputs((Iterable)this.underlyingParDo.getSideInputs()).withOutputTags(mainOutputTag, TupleTagList.empty()));
            PCollection output = outputs.get(mainOutputTag);
            output.setTypeDescriptor(this.underlyingParDo.getNewFn().getOutputTypeDescriptor());
            return output;
        }
    }
}

