/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.runners.direct.AutoValue_DirectMetrics_DirectMetricQueryResults;
import org.apache.beam.runners.direct.AutoValue_DirectMetrics_DirectMetricResult;
import org.apache.beam.runners.direct.DirectRunner;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Objects;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.metrics.DistributionData;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricUpdates;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.metrics.MetricsMap;

class DirectMetrics
extends MetricResults {
    private static final ExecutorService COUNTER_COMMITTER = Executors.newCachedThreadPool();
    private static final MetricAggregation<Long, Long> COUNTER = new MetricAggregation<Long, Long>(){

        @Override
        public Long zero() {
            return 0L;
        }

        @Override
        public Long combine(Iterable<Long> updates) {
            long value = 0L;
            for (long update : updates) {
                value += update;
            }
            return value;
        }

        @Override
        public Long extract(Long data) {
            return data;
        }
    };
    private static final MetricAggregation<DistributionData, DistributionResult> DISTRIBUTION = new MetricAggregation<DistributionData, DistributionResult>(){

        @Override
        public DistributionData zero() {
            return DistributionData.EMPTY;
        }

        @Override
        public DistributionData combine(Iterable<DistributionData> updates) {
            DistributionData result = DistributionData.EMPTY;
            for (DistributionData update : updates) {
                result = result.combine(update);
            }
            return result;
        }

        @Override
        public DistributionResult extract(DistributionData data) {
            return data.extractResult();
        }
    };
    private MetricsMap<MetricKey, DirectMetric<Long, Long>> counters = new MetricsMap((MetricsMap.Factory)new MetricsMap.Factory<MetricKey, DirectMetric<Long, Long>>(){

        public DirectMetric<Long, Long> createInstance(MetricKey unusedKey) {
            return new DirectMetric<Long, Long>(COUNTER);
        }
    });
    private MetricsMap<MetricKey, DirectMetric<DistributionData, DistributionResult>> distributions = new MetricsMap((MetricsMap.Factory)new MetricsMap.Factory<MetricKey, DirectMetric<DistributionData, DistributionResult>>(){

        public DirectMetric<DistributionData, DistributionResult> createInstance(MetricKey unusedKey) {
            return new DirectMetric<DistributionData, DistributionResult>(DISTRIBUTION);
        }
    });

    DirectMetrics() {
    }

    public MetricQueryResults queryMetrics(MetricsFilter filter) {
        ImmutableList.Builder counterResults = ImmutableList.builder();
        for (Map.Entry counter : this.counters.entries()) {
            this.maybeExtractResult(filter, counterResults, counter);
        }
        ImmutableList.Builder distributionResults = ImmutableList.builder();
        for (Map.Entry distribution : this.distributions.entries()) {
            this.maybeExtractResult(filter, distributionResults, distribution);
        }
        return DirectMetricQueryResults.create(counterResults.build(), distributionResults.build());
    }

    private <ResultT> void maybeExtractResult(MetricsFilter filter, ImmutableList.Builder<MetricResult<ResultT>> resultsBuilder, Map.Entry<MetricKey, ? extends DirectMetric<?, ResultT>> entry) {
        if (this.matches(filter, entry.getKey())) {
            resultsBuilder.add((Object)DirectMetricResult.create(entry.getKey().metricName(), entry.getKey().stepName(), entry.getValue().extractCommitted(), entry.getValue().extractLatestAttempted()));
        }
    }

    private boolean matches(MetricsFilter filter, MetricKey key) {
        return this.matchesName(key.metricName(), filter.names()) && this.matchesScope(key.stepName(), filter.steps());
    }

    private boolean matchesScope(String actualScope, Set<String> scopes) {
        if (scopes.isEmpty() || scopes.contains(actualScope)) {
            return true;
        }
        for (String scope : scopes) {
            if (!actualScope.startsWith(scope)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesName(MetricName metricName, Set<MetricNameFilter> nameFilters) {
        if (nameFilters.isEmpty()) {
            return true;
        }
        for (MetricNameFilter nameFilter : nameFilters) {
            if (nameFilter.getName() != null && !nameFilter.getName().equals(metricName.name()) || !Objects.equal(metricName.namespace(), nameFilter.getNamespace())) continue;
            return true;
        }
        return false;
    }

    public void updatePhysical(DirectRunner.CommittedBundle<?> bundle, MetricUpdates updates) {
        for (MetricUpdates.MetricUpdate counter : updates.counterUpdates()) {
            ((DirectMetric)this.counters.get((Object)counter.getKey())).updatePhysical(bundle, counter.getUpdate());
        }
        for (MetricUpdates.MetricUpdate distribution : updates.distributionUpdates()) {
            ((DirectMetric)this.distributions.get((Object)distribution.getKey())).updatePhysical(bundle, distribution.getUpdate());
        }
    }

    public void commitPhysical(DirectRunner.CommittedBundle<?> bundle, MetricUpdates updates) {
        for (MetricUpdates.MetricUpdate counter : updates.counterUpdates()) {
            ((DirectMetric)this.counters.get((Object)counter.getKey())).commitPhysical(bundle, counter.getUpdate());
        }
        for (MetricUpdates.MetricUpdate distribution : updates.distributionUpdates()) {
            ((DirectMetric)this.distributions.get((Object)distribution.getKey())).commitPhysical(bundle, distribution.getUpdate());
        }
    }

    public void commitLogical(DirectRunner.CommittedBundle<?> bundle, MetricUpdates updates) {
        for (MetricUpdates.MetricUpdate counter : updates.counterUpdates()) {
            ((DirectMetric)this.counters.get((Object)counter.getKey())).commitLogical(bundle, counter.getUpdate());
        }
        for (MetricUpdates.MetricUpdate distribution : updates.distributionUpdates()) {
            ((DirectMetric)this.distributions.get((Object)distribution.getKey())).commitLogical(bundle, distribution.getUpdate());
        }
    }

    static abstract class DirectMetricResult<T>
    implements MetricResult<T> {
        DirectMetricResult() {
        }

        public abstract MetricName name();

        public abstract String step();

        public abstract T committed();

        public abstract T attempted();

        public static <T> MetricResult<T> create(MetricName name, String scope, T committed, T attempted) {
            return new AutoValue_DirectMetrics_DirectMetricResult<T>(name, scope, committed, attempted);
        }
    }

    static abstract class DirectMetricQueryResults
    implements MetricQueryResults {
        DirectMetricQueryResults() {
        }

        public static MetricQueryResults create(Iterable<MetricResult<Long>> counters, Iterable<MetricResult<DistributionResult>> distributions) {
            return new AutoValue_DirectMetrics_DirectMetricQueryResults(counters, distributions);
        }
    }

    private static class DirectMetric<UpdateT, ResultT> {
        private final MetricAggregation<UpdateT, ResultT> aggregation;
        private final AtomicReference<UpdateT> finishedCommitted;
        private final Object attemptedLock = new Object();
        @GuardedBy(value="attemptedLock")
        private volatile UpdateT finishedAttempted;
        @GuardedBy(value="attemptedLock")
        private final ConcurrentMap<DirectRunner.CommittedBundle<?>, UpdateT> inflightAttempted = new ConcurrentHashMap();

        public DirectMetric(MetricAggregation<UpdateT, ResultT> aggregation) {
            this.aggregation = aggregation;
            this.finishedCommitted = new AtomicReference<UpdateT>(aggregation.zero());
            this.finishedAttempted = aggregation.zero();
        }

        public void updatePhysical(DirectRunner.CommittedBundle<?> bundle, UpdateT tentativeCumulative) {
            this.inflightAttempted.put(bundle, tentativeCumulative);
        }

        public void commitPhysical(final DirectRunner.CommittedBundle<?> bundle, final UpdateT finalCumulative) {
            this.inflightAttempted.put(bundle, finalCumulative);
            COUNTER_COMMITTER.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = DirectMetric.this.attemptedLock;
                    synchronized (object) {
                        DirectMetric.this.finishedAttempted = DirectMetric.this.aggregation.combine(Arrays.asList(DirectMetric.this.finishedAttempted, finalCumulative));
                        DirectMetric.this.inflightAttempted.remove(bundle);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResultT extractLatestAttempted() {
            ArrayList<Object> updates = new ArrayList<Object>(this.inflightAttempted.size() + 1);
            Object object = this.attemptedLock;
            synchronized (object) {
                updates.add(this.finishedAttempted);
                updates.addAll(this.inflightAttempted.values());
            }
            return this.aggregation.extract(this.aggregation.combine(updates));
        }

        public void commitLogical(DirectRunner.CommittedBundle<?> bundle, UpdateT finalCumulative) {
            UpdateT current;
            do {
                current = this.finishedCommitted.get();
            } while (!this.finishedCommitted.compareAndSet(current, this.aggregation.combine(Arrays.asList(current, finalCumulative))));
        }

        public ResultT extractCommitted() {
            return this.aggregation.extract(this.finishedCommitted.get());
        }
    }

    private static interface MetricAggregation<UpdateT, ResultT> {
        public UpdateT zero();

        public UpdateT combine(Iterable<UpdateT> var1);

        public ResultT extract(UpdateT var1);
    }
}

