/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.CacheBuilder;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.CacheLoader;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.LoadingCache;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.RemovalListener;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.RemovalNotification;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.util.SerializableUtils;

class DoFnLifecycleManager {
    private final LoadingCache<Thread, DoFn<?, ?>> outstanding;
    private final ConcurrentMap<Thread, Exception> thrownOnTeardown;

    public static DoFnLifecycleManager of(DoFn<?, ?> original) {
        return new DoFnLifecycleManager(original);
    }

    private DoFnLifecycleManager(DoFn<?, ?> original) {
        this.outstanding = CacheBuilder.newBuilder().removalListener(new TeardownRemovedFnListener()).build(new DeserializingCacheLoader(original));
        this.thrownOnTeardown = new ConcurrentHashMap<Thread, Exception>();
    }

    public <InputT, OutputT> DoFn<InputT, OutputT> get() throws Exception {
        Thread currentThread = Thread.currentThread();
        return this.outstanding.get(currentThread);
    }

    public void remove() throws Exception {
        Thread currentThread = Thread.currentThread();
        this.outstanding.invalidate(currentThread);
        this.outstanding.cleanUp();
        Exception thrown = (Exception)this.thrownOnTeardown.remove(currentThread);
        if (thrown != null) {
            throw thrown;
        }
    }

    public Collection<Exception> removeAll() throws Exception {
        this.outstanding.invalidateAll();
        this.outstanding.cleanUp();
        return this.thrownOnTeardown.values();
    }

    private class TeardownRemovedFnListener
    implements RemovalListener<Thread, DoFn<?, ?>> {
        private TeardownRemovedFnListener() {
        }

        @Override
        public void onRemoval(RemovalNotification<Thread, DoFn<?, ?>> notification) {
            try {
                DoFnInvokers.invokerFor(notification.getValue()).invokeTeardown();
            }
            catch (Exception e) {
                DoFnLifecycleManager.this.thrownOnTeardown.put(notification.getKey(), e);
            }
        }
    }

    private static class DeserializingCacheLoader
    extends CacheLoader<Thread, DoFn<?, ?>> {
        private final byte[] original;

        public DeserializingCacheLoader(DoFn<?, ?> original) {
            this.original = SerializableUtils.serializeToByteArray(original);
        }

        @Override
        public DoFn<?, ?> load(Thread key) throws Exception {
            DoFn fn = (DoFn)SerializableUtils.deserializeFromByteArray((byte[])this.original, (String)("DoFn Copy in thread " + key.getName()));
            DoFnInvokers.invokerFor((DoFn)fn).invokeSetup();
            return fn;
        }
    }
}

