/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.runners.direct.CommittedResult;
import org.apache.beam.runners.direct.DirectRunner;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.ForwardingPTransform;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.AppliedPTransform;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TaggedPValue;

class ViewEvaluatorFactory
implements TransformEvaluatorFactory {
    private final EvaluationContext context;

    ViewEvaluatorFactory(EvaluationContext context) {
        this.context = context;
    }

    public <T> TransformEvaluator<T> forApplication(AppliedPTransform<?, ?, ?> application, DirectRunner.CommittedBundle<?> inputBundle) {
        TransformEvaluator evaluator = this.createEvaluator(application);
        return evaluator;
    }

    @Override
    public void cleanup() throws Exception {
    }

    private <InT, OuT> TransformEvaluator<Iterable<InT>> createEvaluator(final AppliedPTransform<PCollection<Iterable<InT>>, PCollectionView<OuT>, WriteView<InT, OuT>> application) {
        PCollection input = (PCollection)((TaggedPValue)Iterables.getOnlyElement(application.getInputs())).getValue();
        final DirectRunner.PCollectionViewWriter writer = this.context.createPCollectionViewWriter(input, (PCollectionView)((TaggedPValue)Iterables.getOnlyElement(application.getOutputs())).getValue());
        return new TransformEvaluator<Iterable<InT>>(){
            private final List<WindowedValue<InT>> elements = new ArrayList();

            @Override
            public void processElement(WindowedValue<Iterable<InT>> element) {
                for (Object input : (Iterable)element.getValue()) {
                    this.elements.add(element.withValue(input));
                }
            }

            @Override
            public TransformResult<Iterable<InT>> finishBundle() {
                writer.add(this.elements);
                StepTransformResult.Builder resultBuilder = StepTransformResult.withoutHold(application);
                if (!this.elements.isEmpty()) {
                    resultBuilder = resultBuilder.withAdditionalOutput(CommittedResult.OutputType.PCOLLECTION_VIEW);
                }
                return resultBuilder.build();
            }
        };
    }

    public static final class WriteView<ElemT, ViewT>
    extends PTransform<PCollection<Iterable<ElemT>>, PCollectionView<ViewT>> {
        private final View.CreatePCollectionView<ElemT, ViewT> og;

        WriteView(View.CreatePCollectionView<ElemT, ViewT> og) {
            this.og = og;
        }

        public PCollectionView<ViewT> expand(PCollection<Iterable<ElemT>> input) {
            return this.og.getView();
        }
    }

    private static class DirectCreatePCollectionView<ElemT, ViewT>
    extends ForwardingPTransform<PCollection<ElemT>, PCollectionView<ViewT>> {
        private final View.CreatePCollectionView<ElemT, ViewT> og;

        private DirectCreatePCollectionView(View.CreatePCollectionView<ElemT, ViewT> og) {
            this.og = og;
        }

        @Override
        public PCollectionView<ViewT> expand(PCollection<ElemT> input) {
            return (PCollectionView)((PCollection)((PCollection)((PCollection)input.apply((PTransform)WithKeys.of((Object)null))).setCoder((Coder)KvCoder.of((Coder)VoidCoder.of(), (Coder)input.getCoder())).apply((PTransform)GroupByKey.create())).apply((PTransform)Values.create())).apply(new WriteView<ElemT, ViewT>(this.og));
        }

        @Override
        protected PTransform<PCollection<ElemT>, PCollectionView<ViewT>> delegate() {
            return this.og;
        }
    }

    public static class ViewOverrideFactory<ElemT, ViewT>
    implements PTransformOverrideFactory<PCollection<ElemT>, PCollectionView<ViewT>, View.CreatePCollectionView<ElemT, ViewT>> {
        public PTransform<PCollection<ElemT>, PCollectionView<ViewT>> getReplacementTransform(View.CreatePCollectionView<ElemT, ViewT> transform) {
            return new DirectCreatePCollectionView(transform);
        }
    }
}

