/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.runners.core.AggregatorFactory;
import org.apache.beam.runners.core.ExecutionContext;
import org.apache.beam.runners.direct.AutoValue_AggregatorContainer_AggregatorKey;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdk.transforms.Aggregator;
import org.apache.beam.sdk.transforms.Combine;

public class AggregatorContainer {
    private final ConcurrentMap<AggregatorKey, AggregatorInfo<?, ?, ?>> accumulators = new ConcurrentHashMap();

    private AggregatorContainer() {
    }

    public static AggregatorContainer create() {
        return new AggregatorContainer();
    }

    @Nullable
    <OutputT> OutputT getAggregate(String stepName, String aggregatorName) {
        AggregatorInfo aggregatorInfo = (AggregatorInfo)this.accumulators.get(AggregatorKey.create(stepName, aggregatorName));
        return aggregatorInfo == null ? null : (OutputT)aggregatorInfo.getOutput();
    }

    public Mutator createMutator() {
        return new Mutator(this);
    }

    public static abstract class AggregatorKey {
        public static AggregatorKey create(String stepName, String aggregatorName) {
            return new AutoValue_AggregatorContainer_AggregatorKey(stepName, aggregatorName);
        }

        public abstract String getStepName();

        public abstract String aggregatorName();
    }

    public static class Mutator
    implements AggregatorFactory {
        private final Map<AggregatorKey, AggregatorInfo<?, ?, ?>> accumulatorDeltas = new HashMap();
        private final AggregatorContainer container;
        private boolean committed = false;

        private Mutator(AggregatorContainer container) {
            this.container = container;
        }

        public void commit() {
            Preconditions.checkState(!this.committed, "Should not be already committed");
            this.committed = true;
            for (Map.Entry<AggregatorKey, AggregatorInfo<?, ?, ?>> entry : this.accumulatorDeltas.entrySet()) {
                AggregatorInfo<?, ?, ?> previous = (AggregatorInfo<?, ?, ?>)this.container.accumulators.get(entry.getKey());
                ((AggregatorInfo)entry.getValue()).committed = true;
                if (previous == null) {
                    previous = this.container.accumulators.putIfAbsent(entry.getKey(), entry.getValue());
                }
                if (previous == null) continue;
                ((AggregatorInfo)previous).merge((AggregatorInfo)entry.getValue());
                ((AggregatorInfo)previous).committed = true;
            }
        }

        public <InputT, AccumT, OutputT> Aggregator<InputT, OutputT> createAggregatorForDoFn(Class<?> fnClass, ExecutionContext.StepContext step, String name, Combine.CombineFn<InputT, AccumT, OutputT> combine) {
            return this.createAggregatorForStep(step, name, combine);
        }

        public <InputT, AccumT, OutputT> Aggregator<InputT, OutputT> createSystemAggregator(ExecutionContext.StepContext step, String name, Combine.CombineFn<InputT, AccumT, OutputT> combiner) {
            return this.createAggregatorForStep(step, name, combiner);
        }

        private <InputT, AccumT, OutputT> Aggregator<InputT, OutputT> createAggregatorForStep(ExecutionContext.StepContext step, String name, Combine.CombineFn<InputT, AccumT, OutputT> combine) {
            Preconditions.checkState(!this.committed, "Cannot create aggregators after committing");
            AggregatorKey key = AggregatorKey.create(step.getStepName(), name);
            AggregatorInfo<?, ?, ?> aggregatorInfo = this.accumulatorDeltas.get(key);
            if (aggregatorInfo != null) {
                AggregatorInfo<?, ?, ?> typedAggregatorInfo = aggregatorInfo;
                return typedAggregatorInfo;
            }
            AggregatorInfo typedAggregatorInfo = new AggregatorInfo(step.getStepName(), name, combine);
            this.accumulatorDeltas.put(key, typedAggregatorInfo);
            return typedAggregatorInfo;
        }
    }

    private static class AggregatorInfo<InputT, AccumT, OutputT>
    implements Aggregator<InputT, OutputT> {
        private final String stepName;
        private final String name;
        private final Combine.CombineFn<InputT, AccumT, OutputT> combiner;
        @GuardedBy(value="this")
        private volatile AccumT accumulator = null;
        private boolean committed = false;

        private AggregatorInfo(String stepName, String name, Combine.CombineFn<InputT, AccumT, OutputT> combiner) {
            this.stepName = stepName;
            this.name = name;
            this.combiner = combiner;
        }

        public synchronized void addValue(InputT input) {
            Preconditions.checkState(!this.committed, "Cannot addValue after committing");
            if (this.accumulator == null) {
                this.accumulator = this.combiner.createAccumulator();
            }
            this.accumulator = this.combiner.addInput(this.accumulator, input);
        }

        public synchronized OutputT getOutput() {
            return (OutputT)(this.accumulator == null ? null : this.combiner.extractOutput(this.accumulator));
        }

        private void merge(AggregatorInfo<?, ?, ?> other) {
            AggregatorInfo<?, ?, ?> otherSafe = other;
            this.mergeSafe(otherSafe);
        }

        private synchronized void mergeSafe(AggregatorInfo<InputT, AccumT, OutputT> other) {
            if (this.accumulator == null) {
                this.accumulator = other.accumulator;
            } else if (other.accumulator != null) {
                this.accumulator = this.combiner.mergeAccumulators(Arrays.asList(this.accumulator, other.accumulator));
            }
        }

        public String getStepName() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public Combine.CombineFn<InputT, ?, OutputT> getCombineFn() {
            return this.combiner;
        }
    }
}

