/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.runners.core.BaseExecutionContext;
import org.apache.beam.runners.core.ExecutionContext;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.CopyOnAccessInMemoryStateInternals;
import org.apache.beam.runners.direct.DirectTimerInternals;
import org.apache.beam.runners.direct.StructuralKey;
import org.apache.beam.runners.direct.WatermarkManager;

class DirectExecutionContext
extends BaseExecutionContext<DirectStepContext> {
    private final Clock clock;
    private final StructuralKey<?> key;
    private final CopyOnAccessInMemoryStateInternals<Object> existingState;
    private final WatermarkManager.TransformWatermarks watermarks;

    public DirectExecutionContext(Clock clock, StructuralKey<?> key, CopyOnAccessInMemoryStateInternals<Object> existingState, WatermarkManager.TransformWatermarks watermarks) {
        this.clock = clock;
        this.key = key;
        this.existingState = existingState;
        this.watermarks = watermarks;
    }

    protected DirectStepContext createStepContext(String stepName, String transformName) {
        return new DirectStepContext((ExecutionContext)this, stepName, transformName);
    }

    public class DirectStepContext
    extends BaseExecutionContext.StepContext {
        private CopyOnAccessInMemoryStateInternals<Object> stateInternals;
        private DirectTimerInternals timerInternals;

        public DirectStepContext(ExecutionContext executionContext, String stepName, String transformName) {
            super(executionContext, stepName, transformName);
        }

        public CopyOnAccessInMemoryStateInternals<Object> stateInternals() {
            if (this.stateInternals == null) {
                this.stateInternals = CopyOnAccessInMemoryStateInternals.withUnderlying(DirectExecutionContext.this.key, DirectExecutionContext.this.existingState);
            }
            return this.stateInternals;
        }

        public DirectTimerInternals timerInternals() {
            if (this.timerInternals == null) {
                this.timerInternals = DirectTimerInternals.create(DirectExecutionContext.this.clock, DirectExecutionContext.this.watermarks, WatermarkManager.TimerUpdate.builder(DirectExecutionContext.this.key));
            }
            return this.timerInternals;
        }

        public CopyOnAccessInMemoryStateInternals<?> commitState() {
            if (this.stateInternals != null) {
                return this.stateInternals.commit();
            }
            return null;
        }

        public WatermarkManager.TimerUpdate getTimerUpdate() {
            if (this.timerInternals == null) {
                return WatermarkManager.TimerUpdate.empty();
            }
            return this.timerInternals.getTimerUpdate();
        }
    }
}

