/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.runners.direct.DirectRunner;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.sdk.transforms.AppliedPTransform;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TaggedPValue;

class FlattenEvaluatorFactory
implements TransformEvaluatorFactory {
    private final EvaluationContext evaluationContext;

    FlattenEvaluatorFactory(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    @Override
    public <InputT> TransformEvaluator<InputT> forApplication(AppliedPTransform<?, ?, ?> application, DirectRunner.CommittedBundle<?> inputBundle) {
        TransformEvaluator<InputT> evaluator = this.createInMemoryEvaluator(application);
        return evaluator;
    }

    @Override
    public void cleanup() throws Exception {
    }

    private <InputT> TransformEvaluator<InputT> createInMemoryEvaluator(AppliedPTransform<PCollectionList<InputT>, PCollection<InputT>, Flatten.FlattenPCollectionList<InputT>> application) {
        DirectRunner.UncommittedBundle outputBundle = this.evaluationContext.createBundle((PCollection)((TaggedPValue)Iterables.getOnlyElement(application.getOutputs())).getValue());
        StepTransformResult result = StepTransformResult.withoutHold(application).addOutput(outputBundle, new DirectRunner.UncommittedBundle[0]).build();
        return new FlattenEvaluator(outputBundle, result);
    }

    private static class FlattenEvaluator<InputT>
    implements TransformEvaluator<InputT> {
        private final DirectRunner.UncommittedBundle<InputT> outputBundle;
        private final TransformResult<InputT> result;

        public FlattenEvaluator(DirectRunner.UncommittedBundle<InputT> outputBundle, TransformResult<InputT> result) {
            this.outputBundle = outputBundle;
            this.result = result;
        }

        @Override
        public void processElement(WindowedValue<InputT> element) {
            this.outputBundle.add(element);
        }

        @Override
        public TransformResult<InputT> finishBundle() {
            return this.result;
        }
    }
}

