/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.apache.beam.runners.direct.AggregatorContainer;
import org.apache.beam.runners.direct.AutoValue_StepTransformResult;
import org.apache.beam.runners.direct.CommittedResult;
import org.apache.beam.runners.direct.CopyOnAccessInMemoryStateInternals;
import org.apache.beam.runners.direct.DirectRunner;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.metrics.MetricUpdates;
import org.apache.beam.sdk.transforms.AppliedPTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.joda.time.Instant;

public abstract class StepTransformResult<InputT>
implements TransformResult<InputT> {
    public static <InputT> Builder<InputT> withHold(AppliedPTransform<?, ?, ?> transform, Instant watermarkHold) {
        return new Builder(transform, watermarkHold);
    }

    public static <InputT> Builder<InputT> withoutHold(AppliedPTransform<?, ?, ?> transform) {
        return new Builder(transform, BoundedWindow.TIMESTAMP_MAX_VALUE);
    }

    @Override
    public TransformResult<InputT> withLogicalMetricUpdates(MetricUpdates metricUpdates) {
        return new AutoValue_StepTransformResult(this.getTransform(), this.getOutputBundles(), this.getUnprocessedElements(), this.getAggregatorChanges(), metricUpdates, this.getWatermarkHold(), this.getState(), this.getTimerUpdate(), this.getOutputTypes());
    }

    public static class Builder<InputT> {
        private final AppliedPTransform<?, ?, ?> transform;
        private final ImmutableList.Builder<DirectRunner.UncommittedBundle<?>> bundlesBuilder;
        private final ImmutableList.Builder<WindowedValue<InputT>> unprocessedElementsBuilder;
        private MetricUpdates metricUpdates;
        private CopyOnAccessInMemoryStateInternals<?> state;
        private WatermarkManager.TimerUpdate timerUpdate;
        private AggregatorContainer.Mutator aggregatorChanges;
        private final Set<CommittedResult.OutputType> producedOutputs;
        private final Instant watermarkHold;

        private Builder(AppliedPTransform<?, ?, ?> transform, Instant watermarkHold) {
            this.transform = transform;
            this.watermarkHold = watermarkHold;
            this.bundlesBuilder = ImmutableList.builder();
            this.producedOutputs = EnumSet.noneOf(CommittedResult.OutputType.class);
            this.unprocessedElementsBuilder = ImmutableList.builder();
            this.timerUpdate = WatermarkManager.TimerUpdate.builder(null).build();
            this.metricUpdates = MetricUpdates.EMPTY;
        }

        public StepTransformResult<InputT> build() {
            return new AutoValue_StepTransformResult(this.transform, this.bundlesBuilder.build(), this.unprocessedElementsBuilder.build(), this.aggregatorChanges, this.metricUpdates, this.watermarkHold, this.state, this.timerUpdate, this.producedOutputs);
        }

        public Builder<InputT> withAggregatorChanges(AggregatorContainer.Mutator aggregatorChanges) {
            this.aggregatorChanges = aggregatorChanges;
            return this;
        }

        public Builder<InputT> withMetricUpdates(MetricUpdates metricUpdates) {
            this.metricUpdates = metricUpdates;
            return this;
        }

        public Builder<InputT> withState(CopyOnAccessInMemoryStateInternals<?> state) {
            this.state = state;
            return this;
        }

        public Builder<InputT> withTimerUpdate(WatermarkManager.TimerUpdate timerUpdate) {
            this.timerUpdate = timerUpdate;
            return this;
        }

        public Builder<InputT> addUnprocessedElements(WindowedValue<InputT> ... unprocessed) {
            this.unprocessedElementsBuilder.addAll(Arrays.asList(unprocessed));
            return this;
        }

        public Builder<InputT> addUnprocessedElements(Iterable<? extends WindowedValue<InputT>> unprocessed) {
            this.unprocessedElementsBuilder.addAll(unprocessed);
            return this;
        }

        public Builder<InputT> addOutput(DirectRunner.UncommittedBundle<?> outputBundle, DirectRunner.UncommittedBundle<?> ... outputBundles) {
            this.bundlesBuilder.add((Object)outputBundle);
            this.bundlesBuilder.add(outputBundles);
            return this;
        }

        public Builder<InputT> addOutput(Collection<DirectRunner.UncommittedBundle<?>> outputBundles) {
            this.bundlesBuilder.addAll(outputBundles);
            return this;
        }

        public Builder<InputT> withAdditionalOutput(CommittedResult.OutputType producedAdditionalOutput) {
            this.producedOutputs.add(producedAdditionalOutput);
            return this;
        }
    }
}

