/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.runners.direct.TransformExecutor;
import org.apache.beam.runners.direct.TransformExecutorService;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.MoreObjects;

final class TransformExecutorServices {
    private TransformExecutorServices() {
    }

    public static TransformExecutorService parallel(ExecutorService executor) {
        return new ParallelEvaluationState(executor);
    }

    public static TransformExecutorService serial(ExecutorService executor) {
        return new SerialEvaluationState(executor);
    }

    private static class SerialEvaluationState
    implements TransformExecutorService {
        private final ExecutorService executor;
        private AtomicReference<TransformExecutor<?>> currentlyEvaluating;
        private final Queue<TransformExecutor<?>> workQueue;

        private SerialEvaluationState(ExecutorService executor) {
            this.executor = executor;
            this.currentlyEvaluating = new AtomicReference();
            this.workQueue = new ConcurrentLinkedQueue();
        }

        @Override
        public void schedule(TransformExecutor<?> work) {
            this.workQueue.offer(work);
            this.updateCurrentlyEvaluating();
        }

        @Override
        public void complete(TransformExecutor<?> completed) {
            if (!this.currentlyEvaluating.compareAndSet(completed, null)) {
                throw new IllegalStateException("Finished work " + completed + " but could not complete due to unexpected currently executing " + this.currentlyEvaluating.get());
            }
            this.updateCurrentlyEvaluating();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCurrentlyEvaluating() {
            if (this.currentlyEvaluating.get() == null) {
                SerialEvaluationState serialEvaluationState = this;
                synchronized (serialEvaluationState) {
                    TransformExecutor<?> newWork = this.workQueue.poll();
                    if (newWork != null) {
                        if (this.currentlyEvaluating.compareAndSet(null, newWork)) {
                            this.executor.submit(newWork);
                        } else {
                            this.workQueue.offer(newWork);
                        }
                    }
                }
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper(SerialEvaluationState.class).add("currentlyEvaluating", this.currentlyEvaluating).add("workQueue", this.workQueue).toString();
        }
    }

    private static class ParallelEvaluationState
    implements TransformExecutorService {
        private final ExecutorService executor;

        private ParallelEvaluationState(ExecutorService executor) {
            this.executor = executor;
        }

        @Override
        public void schedule(TransformExecutor<?> work) {
            this.executor.submit(work);
        }

        @Override
        public void complete(TransformExecutor<?> completed) {
        }
    }
}

