/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.runners.direct.BoundedReadEvaluatorFactory;
import org.apache.beam.runners.direct.DirectRunner;
import org.apache.beam.runners.direct.EmptyInputProvider;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.RootInputProvider;
import org.apache.beam.runners.direct.TestStreamEvaluatorFactory;
import org.apache.beam.runners.direct.UnboundedReadEvaluatorFactory;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.transforms.AppliedPTransform;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;

class RootProviderRegistry {
    private final Map<Class<? extends PTransform>, RootInputProvider<?, ?, ?, ?>> providers;

    public static RootProviderRegistry defaultRegistry(EvaluationContext context) {
        ImmutableMap.Builder defaultProviders = ImmutableMap.builder();
        defaultProviders.put(Read.Bounded.class, new BoundedReadEvaluatorFactory.InputProvider(context)).put((Class<Read.Bounded>)Read.Unbounded.class, new UnboundedReadEvaluatorFactory.InputProvider(context)).put((Class<Read.Unbounded>)TestStreamEvaluatorFactory.DirectTestStreamFactory.DirectTestStream.class, new TestStreamEvaluatorFactory.InputProvider(context)).put((Class<TestStreamEvaluatorFactory.DirectTestStreamFactory.DirectTestStream>)Flatten.PCollections.class, new EmptyInputProvider());
        return new RootProviderRegistry(defaultProviders.build());
    }

    private RootProviderRegistry(Map<Class<? extends PTransform>, RootInputProvider<?, ?, ?, ?>> providers) {
        this.providers = providers;
    }

    public Collection<DirectRunner.CommittedBundle<?>> getInitialInputs(AppliedPTransform<?, ?, ?> transform, int targetParallelism) throws Exception {
        Class<?> transformClass = transform.getTransform().getClass();
        RootInputProvider<?, ?, ?, ?> provider = Preconditions.checkNotNull(this.providers.get(transformClass), "Tried to get a %s for a Transform of type %s, but there is no such provider", (Object)RootInputProvider.class.getSimpleName(), (Object)transformClass.getSimpleName());
        return provider.getInitialInputs(transform, targetParallelism);
    }
}

