/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;

public interface SparkPipelineOptions
extends PipelineOptions,
StreamingOptions,
ApplicationNameOptions {
    @Description(value="The url of the spark master to connect to, (e.g. spark://host:port, local[4]).")
    @Default.String(value="local[4]")
    public String getSparkMaster();

    public void setSparkMaster(String var1);

    @Description(value="Batch interval for Spark streaming in milliseconds.")
    @Default.Long(value=1000L)
    public Long getBatchIntervalMillis();

    public void setBatchIntervalMillis(Long var1);

    @Description(value="Batch default storage level")
    @Default.String(value="MEMORY_ONLY")
    public String getStorageLevel();

    public void setStorageLevel(String var1);

    @Description(value="Minimum time to spend on read, for each micro-batch.")
    @Default.Long(value=200L)
    public Long getMinReadTimeMillis();

    public void setMinReadTimeMillis(Long var1);

    @Description(value="Max records per micro-batch. For streaming sources only.")
    @Default.Long(value=-1L)
    public Long getMaxRecordsPerBatch();

    public void setMaxRecordsPerBatch(Long var1);

    @Description(value="A value between 0-1 to describe the percentage of a micro-batch dedicated to reading from UnboundedSource.")
    @Default.Double(value=0.1)
    public Double getReadTimePercentage();

    public void setReadTimePercentage(Double var1);

    @Description(value="A checkpoint directory for streaming resilience, ignored in batch. For durability, a reliable filesystem such as HDFS/S3/GS is necessary.")
    @Default.InstanceFactory(value=TmpCheckpointDirFactory.class)
    public String getCheckpointDir();

    public void setCheckpointDir(String var1);

    @Description(value="The period to checkpoint (in Millis). If not set, Spark will default to Max(slideDuration, Seconds(10)). This PipelineOptions default (-1) will end-up with the described Spark default.")
    @Default.Long(value=-1L)
    public Long getCheckpointDurationMillis();

    public void setCheckpointDurationMillis(Long var1);

    @Description(value="Enable/disable sending aggregator values to Spark's metric sinks")
    @Default.Boolean(value=true)
    public Boolean getEnableSparkMetricSinks();

    public void setEnableSparkMetricSinks(Boolean var1);

    @Description(value="If the spark runner will be initialized with a provided Spark Context. The Spark Context should be provided with SparkContextOptions.")
    @Default.Boolean(value=false)
    public boolean getUsesProvidedSparkContext();

    public void setUsesProvidedSparkContext(boolean var1);

    public static class TmpCheckpointDirFactory
    implements DefaultValueFactory<String> {
        public String create(PipelineOptions options) {
            return "/tmp/" + ((SparkPipelineOptions)options.as(SparkPipelineOptions.class)).getJobName();
        }
    }
}

