/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.coders;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Source;
import org.apache.spark.serializer.KryoRegistrator;
import org.reflections.Reflections;

public class BeamSparkRunnerRegistrator
implements KryoRegistrator {
    public void registerClasses(Kryo kryo) {
        for (Class<?> clazz : ClassesForJavaSerialization.getClasses()) {
            kryo.register(clazz, (Serializer)new JavaSerializer());
        }
    }

    private static class ClassesForJavaSerialization {
        private static final Class<?>[] CLASSES_FOR_JAVA_SERIALIZATION = new Class[]{Coder.class, Source.class};
        private static final Iterable<Class<?>> INSTANCE;

        private ClassesForJavaSerialization() {
        }

        static Iterable<Class<?>> getClasses() {
            return INSTANCE;
        }

        static {
            final Reflections reflections = new Reflections(new Object[0]);
            INSTANCE = Iterables.concat((Iterable)Lists.transform(Arrays.asList(CLASSES_FOR_JAVA_SERIALIZATION), (Function)new Function<Class, Set<Class<?>>>(){

                @Nullable
                public Set<Class<?>> apply(@Nullable Class clazz) {
                    return reflections.getSubTypesOf(clazz);
                }
            }));
        }
    }
}

