/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.examples;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Aggregator;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.OldDoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

public class WordCount {
    public static void main(String[] args) {
        WordCountOptions options = (WordCountOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(WordCountOptions.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)p.apply("ReadLines", (PTransform)TextIO.Read.from((String)options.getInputFile()))).apply((PTransform)new CountWords())).apply((PTransform)MapElements.via((SimpleFunction)new FormatAsTextFn()))).apply("WriteCounts", (PTransform)TextIO.Write.to((String)options.getOutput()));
        p.run().waitUntilFinish();
    }

    public static interface WordCountOptions
    extends PipelineOptions {
        @Description(value="Path of the file to read from")
        @Default.String(value="gs://beam-samples/shakespeare/kinglear.txt")
        public String getInputFile();

        public void setInputFile(String var1);

        @Description(value="Path of the file to write to")
        public String getOutput();

        public void setOutput(String var1);
    }

    public static class CountWords
    extends PTransform<PCollection<String>, PCollection<KV<String, Long>>> {
        public PCollection<KV<String, Long>> expand(PCollection<String> lines) {
            PCollection words = (PCollection)lines.apply((PTransform)ParDo.of((OldDoFn)new ExtractWordsFn()));
            PCollection wordCounts = (PCollection)words.apply((PTransform)Count.perElement());
            return wordCounts;
        }
    }

    public static class FormatAsTextFn
    extends SimpleFunction<KV<String, Long>, String> {
        public String apply(KV<String, Long> input) {
            return (String)input.getKey() + ": " + input.getValue();
        }
    }

    static class ExtractWordsFn
    extends OldDoFn<String, String> {
        private final Aggregator<Long, Long> emptyLines = this.createAggregator("emptyLines", (Combine.CombineFn)new Sum.SumLongFn());

        ExtractWordsFn() {
        }

        public void processElement(OldDoFn.ProcessContext c) {
            String[] words;
            if (((String)c.element()).trim().isEmpty()) {
                this.emptyLines.addValue((Object)1L);
            }
            for (String word : words = ((String)c.element()).split("[^a-zA-Z']+")) {
                if (word.isEmpty()) continue;
                c.output((Object)word);
            }
        }
    }
}

