/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io.hadoop;

import java.io.IOException;
import org.apache.beam.runners.spark.io.hadoop.ShardNameBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardNameTemplateHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ShardNameTemplateHelper.class);
    public static final String OUTPUT_FILE_PREFIX = "spark.beam.fileoutputformat.prefix";
    public static final String OUTPUT_FILE_TEMPLATE = "spark.beam.fileoutputformat.template";
    public static final String OUTPUT_FILE_SUFFIX = "spark.beam.fileoutputformat.suffix";

    private ShardNameTemplateHelper() {
    }

    public static <K, V> Path getDefaultWorkFile(FileOutputFormat<K, V> format, TaskAttemptContext context) throws IOException {
        FileOutputCommitter committer = (FileOutputCommitter)format.getOutputCommitter(context);
        return new Path(committer.getWorkPath(), ShardNameTemplateHelper.getOutputFile(context));
    }

    private static String getOutputFile(TaskAttemptContext context) {
        TaskID taskId = context.getTaskAttemptID().getTaskID();
        int partition = taskId.getId();
        String filePrefix = context.getConfiguration().get(OUTPUT_FILE_PREFIX);
        String fileTemplate = context.getConfiguration().get(OUTPUT_FILE_TEMPLATE);
        String fileSuffix = context.getConfiguration().get(OUTPUT_FILE_SUFFIX);
        return filePrefix + ShardNameBuilder.replaceShardNumber(fileTemplate, partition) + fileSuffix;
    }
}

