/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.Map;
import org.apache.beam.runners.spark.aggregators.NamedAggregators;
import org.apache.beam.runners.spark.translation.SparkProcessContext;
import org.apache.beam.runners.spark.translation.SparkRuntimeContext;
import org.apache.beam.runners.spark.util.BroadcastHelper;
import org.apache.beam.sdk.transforms.OldDoFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.spark.Accumulator;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import scala.Tuple2;

public class MultiDoFnFunction<InputT, OutputT>
implements PairFlatMapFunction<Iterator<WindowedValue<InputT>>, TupleTag<?>, WindowedValue<?>> {
    private final Accumulator<NamedAggregators> accum;
    private final OldDoFn<InputT, OutputT> mFunction;
    private final SparkRuntimeContext mRuntimeContext;
    private final TupleTag<OutputT> mMainOutputTag;
    private final Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, BroadcastHelper<?>>> mSideInputs;
    private final WindowFn<Object, ?> windowFn;

    public MultiDoFnFunction(Accumulator<NamedAggregators> accum, OldDoFn<InputT, OutputT> fn, SparkRuntimeContext runtimeContext, TupleTag<OutputT> mainOutputTag, Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, BroadcastHelper<?>>> sideInputs, WindowFn<Object, ?> windowFn) {
        this.accum = accum;
        this.mFunction = fn;
        this.mRuntimeContext = runtimeContext;
        this.mMainOutputTag = mainOutputTag;
        this.mSideInputs = sideInputs;
        this.windowFn = windowFn;
    }

    public Iterable<Tuple2<TupleTag<?>, WindowedValue<?>>> call(Iterator<WindowedValue<InputT>> iter) throws Exception {
        return new ProcCtxt(this.mFunction, this.mRuntimeContext, this.mSideInputs, this.windowFn).callWithCtxt(iter);
    }

    private class ProcCtxt
    extends SparkProcessContext<InputT, OutputT, Tuple2<TupleTag<?>, WindowedValue<?>>> {
        private final Multimap<TupleTag<?>, WindowedValue<?>> outputs;

        ProcCtxt(OldDoFn<InputT, OutputT> fn, SparkRuntimeContext runtimeContext, Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, BroadcastHelper<?>>> sideInputs, WindowFn<Object, ?> windowFn) {
            super(fn, runtimeContext, sideInputs, windowFn);
            this.outputs = LinkedListMultimap.create();
        }

        @Override
        protected synchronized void outputWindowedValue(WindowedValue<OutputT> o) {
            this.outputs.put((Object)MultiDoFnFunction.this.mMainOutputTag, o);
        }

        @Override
        protected <T> void sideOutputWindowedValue(TupleTag<T> tag, WindowedValue<T> output) {
            this.outputs.put(tag, output);
        }

        @Override
        public Accumulator<NamedAggregators> getAccumulator() {
            return MultiDoFnFunction.this.accum;
        }

        @Override
        protected void clearOutput() {
            this.outputs.clear();
        }

        @Override
        protected Iterator<Tuple2<TupleTag<?>, WindowedValue<?>>> getOutputIterator() {
            return Iterators.transform(this.outputs.entries().iterator(), (Function)new Function<Map.Entry<TupleTag<?>, WindowedValue<?>>, Tuple2<TupleTag<?>, WindowedValue<?>>>(){

                public Tuple2<TupleTag<?>, WindowedValue<?>> apply(Map.Entry<TupleTag<?>, WindowedValue<?>> input) {
                    return new Tuple2(input.getKey(), input.getValue());
                }
            });
        }
    }
}

