/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.spark.aggregators.NamedAggregators;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Aggregator;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.spark.Accumulator;

public class SparkRuntimeContext
implements Serializable {
    private final String serializedPipelineOptions;
    private final Map<String, Aggregator<?, ?>> aggregators = new HashMap();
    private transient CoderRegistry coderRegistry;

    SparkRuntimeContext(Pipeline pipeline) {
        this.serializedPipelineOptions = this.serializePipelineOptions(pipeline.getOptions());
    }

    private String serializePipelineOptions(PipelineOptions pipelineOptions) {
        try {
            return new ObjectMapper().writeValueAsString((Object)pipelineOptions);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to serialize the pipeline options.", e);
        }
    }

    private static PipelineOptions deserializePipelineOptions(String serializedPipelineOptions) {
        try {
            return (PipelineOptions)new ObjectMapper().readValue(serializedPipelineOptions, PipelineOptions.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deserialize the pipeline options.", e);
        }
    }

    public synchronized PipelineOptions getPipelineOptions() {
        return SparkRuntimeContext.deserializePipelineOptions(this.serializedPipelineOptions);
    }

    public synchronized <InputT, InterT, OutputT> Aggregator<InputT, OutputT> createAggregator(Accumulator<NamedAggregators> accum, String named, Combine.CombineFn<? super InputT, InterT, OutputT> combineFn) {
        Aggregator<?, ?> aggregator = this.aggregators.get(named);
        if (aggregator == null) {
            NamedAggregators.CombineFunctionState<? super InputT, InterT, OutputT> state = new NamedAggregators.CombineFunctionState<InputT, InterT, OutputT>(combineFn, this.getCoder(combineFn), this);
            accum.add((Object)new NamedAggregators(named, state));
            aggregator = new SparkAggregator(named, state);
            this.aggregators.put(named, aggregator);
        }
        return aggregator;
    }

    public CoderRegistry getCoderRegistry() {
        if (this.coderRegistry == null) {
            this.coderRegistry = new CoderRegistry();
            this.coderRegistry.registerStandardCoders();
        }
        return this.coderRegistry;
    }

    private Coder<?> getCoder(Combine.CombineFn<?, ?, ?> combiner) {
        try {
            if (combiner.getClass() == Sum.SumIntegerFn.class) {
                return this.getCoderRegistry().getDefaultCoder(TypeDescriptor.of(Integer.class));
            }
            if (combiner.getClass() == Sum.SumLongFn.class) {
                return this.getCoderRegistry().getDefaultCoder(TypeDescriptor.of(Long.class));
            }
            if (combiner.getClass() == Sum.SumDoubleFn.class) {
                return this.getCoderRegistry().getDefaultCoder(TypeDescriptor.of(Double.class));
            }
            if (combiner.getClass() == Min.MinIntegerFn.class) {
                return this.getCoderRegistry().getDefaultCoder(TypeDescriptor.of(Integer.class));
            }
            if (combiner.getClass() == Min.MinLongFn.class) {
                return this.getCoderRegistry().getDefaultCoder(TypeDescriptor.of(Long.class));
            }
            if (combiner.getClass() == Min.MinDoubleFn.class) {
                return this.getCoderRegistry().getDefaultCoder(TypeDescriptor.of(Double.class));
            }
            if (combiner.getClass() == Max.MaxIntegerFn.class) {
                return this.getCoderRegistry().getDefaultCoder(TypeDescriptor.of(Integer.class));
            }
            if (combiner.getClass() == Max.MaxLongFn.class) {
                return this.getCoderRegistry().getDefaultCoder(TypeDescriptor.of(Long.class));
            }
            if (combiner.getClass() == Max.MaxDoubleFn.class) {
                return this.getCoderRegistry().getDefaultCoder(TypeDescriptor.of(Double.class));
            }
            throw new IllegalArgumentException("unsupported combiner in Aggregator: " + combiner.getClass().getName());
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalStateException("Could not determine default coder for combiner", e);
        }
    }

    private static class SparkAggregator<InputT, OutputT>
    implements Aggregator<InputT, OutputT>,
    Serializable {
        private final String name;
        private final NamedAggregators.State<InputT, ?, OutputT> state;

        SparkAggregator(String name, NamedAggregators.State<InputT, ?, OutputT> state) {
            this.name = name;
            this.state = state;
        }

        public String getName() {
            return this.name;
        }

        public void addValue(InputT elem) {
            this.state.update(elem);
        }

        public Combine.CombineFn<InputT, ?, OutputT> getCombineFn() {
            return this.state.getCombineFn();
        }
    }
}

