/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import javax.annotation.Nullable;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;

public interface TestSparkPipelineOptions
extends SparkPipelineOptions,
TestPipelineOptions {
    @Description(value="A special flag that forces streaming in tests.")
    @Default.Boolean(value=false)
    public boolean isForceStreaming();

    public void setForceStreaming(boolean var1);

    @Description(value="A hard-coded expected number of assertions for this test pipeline.")
    @Nullable
    public Integer getExpectedAssertions();

    public void setExpectedAssertions(Integer var1);

    @Description(value="A watermark (time in millis) that causes a pipeline that reads from an unbounded source to stop.")
    @Default.InstanceFactory(value=DefaultStopPipelineWatermarkFactory.class)
    public Long getStopPipelineWatermark();

    public void setStopPipelineWatermark(Long var1);

    public static class DefaultStopPipelineWatermarkFactory
    implements DefaultValueFactory<Long> {
        public Long create(PipelineOptions options) {
            return BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis();
        }
    }
}

