/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation.streaming;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnboundedDataset<T>
implements Dataset {
    private static final Logger LOG = LoggerFactory.getLogger(UnboundedDataset.class);
    private JavaDStream<WindowedValue<T>> dStream;
    private final List<Integer> streamSources = new ArrayList<Integer>();

    public UnboundedDataset(JavaDStream<WindowedValue<T>> dStream, List<Integer> streamSources) {
        this.dStream = dStream;
        this.streamSources.addAll(streamSources);
    }

    JavaDStream<WindowedValue<T>> getDStream() {
        return this.dStream;
    }

    List<Integer> getStreamSources() {
        return this.streamSources;
    }

    @Override
    public void cache(String storageLevel, Coder<?> coder) {
        if (!StorageLevel.fromString((String)storageLevel).equals((Object)StorageLevel.MEMORY_ONLY_SER())) {
            LOG.warn("Provided StorageLevel: {} is ignored for streams, using the default level: {}", (Object)storageLevel, (Object)StorageLevel.MEMORY_ONLY_SER());
        }
        Coder<?> wc = coder;
        this.dStream = this.dStream.map(CoderHelpers.toByteFunction(wc)).cache().map(CoderHelpers.fromByteFunction(wc));
    }

    @Override
    public void action() {
        this.dStream.foreachRDD(new VoidFunction<JavaRDD<WindowedValue<T>>>(){

            public void call(JavaRDD<WindowedValue<T>> rdd) throws Exception {
                rdd.foreach(TranslationUtils.emptyVoidFunction());
            }
        });
    }

    @Override
    public void setName(String name) {
    }
}

