package org.apache.beam.fn.v1;

import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;

/**
 * <pre>
 * An API that describes the work that a SDK harness is meant to do.
 * Stable
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.2.0)",
    comments = "Source: beam_fn_api.proto")
public final class BeamFnControlGrpc {

  private BeamFnControlGrpc() {}

  public static final String SERVICE_NAME = "org.apache.beam.fn.v1.BeamFnControl";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<org.apache.beam.fn.v1.BeamFnApi.InstructionResponse,
      org.apache.beam.fn.v1.BeamFnApi.InstructionRequest> METHOD_CONTROL =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING,
          generateFullMethodName(
              "org.apache.beam.fn.v1.BeamFnControl", "Control"),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.fn.v1.BeamFnApi.InstructionResponse.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.fn.v1.BeamFnApi.InstructionRequest.getDefaultInstance()));

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static BeamFnControlStub newStub(io.grpc.Channel channel) {
    return new BeamFnControlStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static BeamFnControlBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new BeamFnControlBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary and streaming output calls on the service
   */
  public static BeamFnControlFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new BeamFnControlFutureStub(channel);
  }

  /**
   * <pre>
   * An API that describes the work that a SDK harness is meant to do.
   * Stable
   * </pre>
   */
  public static abstract class BeamFnControlImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Instructions sent by the runner to the SDK requesting different types
     * of work.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<org.apache.beam.fn.v1.BeamFnApi.InstructionResponse> control(
        io.grpc.stub.StreamObserver<org.apache.beam.fn.v1.BeamFnApi.InstructionRequest> responseObserver) {
      return asyncUnimplementedStreamingCall(METHOD_CONTROL, responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            METHOD_CONTROL,
            asyncBidiStreamingCall(
              new MethodHandlers<
                org.apache.beam.fn.v1.BeamFnApi.InstructionResponse,
                org.apache.beam.fn.v1.BeamFnApi.InstructionRequest>(
                  this, METHODID_CONTROL)))
          .build();
    }
  }

  /**
   * <pre>
   * An API that describes the work that a SDK harness is meant to do.
   * Stable
   * </pre>
   */
  public static final class BeamFnControlStub extends io.grpc.stub.AbstractStub<BeamFnControlStub> {
    private BeamFnControlStub(io.grpc.Channel channel) {
      super(channel);
    }

    private BeamFnControlStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected BeamFnControlStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new BeamFnControlStub(channel, callOptions);
    }

    /**
     * <pre>
     * Instructions sent by the runner to the SDK requesting different types
     * of work.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<org.apache.beam.fn.v1.BeamFnApi.InstructionResponse> control(
        io.grpc.stub.StreamObserver<org.apache.beam.fn.v1.BeamFnApi.InstructionRequest> responseObserver) {
      return asyncBidiStreamingCall(
          getChannel().newCall(METHOD_CONTROL, getCallOptions()), responseObserver);
    }
  }

  /**
   * <pre>
   * An API that describes the work that a SDK harness is meant to do.
   * Stable
   * </pre>
   */
  public static final class BeamFnControlBlockingStub extends io.grpc.stub.AbstractStub<BeamFnControlBlockingStub> {
    private BeamFnControlBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private BeamFnControlBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected BeamFnControlBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new BeamFnControlBlockingStub(channel, callOptions);
    }
  }

  /**
   * <pre>
   * An API that describes the work that a SDK harness is meant to do.
   * Stable
   * </pre>
   */
  public static final class BeamFnControlFutureStub extends io.grpc.stub.AbstractStub<BeamFnControlFutureStub> {
    private BeamFnControlFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private BeamFnControlFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected BeamFnControlFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new BeamFnControlFutureStub(channel, callOptions);
    }
  }

  private static final int METHODID_CONTROL = 0;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final BeamFnControlImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(BeamFnControlImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_CONTROL:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.control(
              (io.grpc.stub.StreamObserver<org.apache.beam.fn.v1.BeamFnApi.InstructionRequest>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  private static final class BeamFnControlDescriptorSupplier implements io.grpc.protobuf.ProtoFileDescriptorSupplier {
    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return org.apache.beam.fn.v1.BeamFnApi.getDescriptor();
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (BeamFnControlGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new BeamFnControlDescriptorSupplier())
              .addMethod(METHOD_CONTROL)
              .build();
        }
      }
    }
    return result;
  }
}
