package org.apache.beam.fn.v1;

import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;

/**
 * <pre>
 * A service to provide runtime provisioning information to the SDK harness
 * worker instances -- such as pipeline options, resource constraints and
 * other job metadata -- needed by an SDK harness instance to initialize.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.2.0)",
    comments = "Source: beam_provision_api.proto")
public final class ProvisionServiceGrpc {

  private ProvisionServiceGrpc() {}

  public static final String SERVICE_NAME = "org.apache.beam.fn.v1.ProvisionService";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoRequest,
      org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoResponse> METHOD_GET_PROVISION_INFO =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.UNARY,
          generateFullMethodName(
              "org.apache.beam.fn.v1.ProvisionService", "GetProvisionInfo"),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoResponse.getDefaultInstance()));

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static ProvisionServiceStub newStub(io.grpc.Channel channel) {
    return new ProvisionServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static ProvisionServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new ProvisionServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary and streaming output calls on the service
   */
  public static ProvisionServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new ProvisionServiceFutureStub(channel);
  }

  /**
   * <pre>
   * A service to provide runtime provisioning information to the SDK harness
   * worker instances -- such as pipeline options, resource constraints and
   * other job metadata -- needed by an SDK harness instance to initialize.
   * </pre>
   */
  public static abstract class ProvisionServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Get provision information for the SDK harness worker instance.
     * </pre>
     */
    public void getProvisionInfo(org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_GET_PROVISION_INFO, responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            METHOD_GET_PROVISION_INFO,
            asyncUnaryCall(
              new MethodHandlers<
                org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoRequest,
                org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoResponse>(
                  this, METHODID_GET_PROVISION_INFO)))
          .build();
    }
  }

  /**
   * <pre>
   * A service to provide runtime provisioning information to the SDK harness
   * worker instances -- such as pipeline options, resource constraints and
   * other job metadata -- needed by an SDK harness instance to initialize.
   * </pre>
   */
  public static final class ProvisionServiceStub extends io.grpc.stub.AbstractStub<ProvisionServiceStub> {
    private ProvisionServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ProvisionServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ProvisionServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ProvisionServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Get provision information for the SDK harness worker instance.
     * </pre>
     */
    public void getProvisionInfo(org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_GET_PROVISION_INFO, getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * A service to provide runtime provisioning information to the SDK harness
   * worker instances -- such as pipeline options, resource constraints and
   * other job metadata -- needed by an SDK harness instance to initialize.
   * </pre>
   */
  public static final class ProvisionServiceBlockingStub extends io.grpc.stub.AbstractStub<ProvisionServiceBlockingStub> {
    private ProvisionServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ProvisionServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ProvisionServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ProvisionServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Get provision information for the SDK harness worker instance.
     * </pre>
     */
    public org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoResponse getProvisionInfo(org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_GET_PROVISION_INFO, getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * A service to provide runtime provisioning information to the SDK harness
   * worker instances -- such as pipeline options, resource constraints and
   * other job metadata -- needed by an SDK harness instance to initialize.
   * </pre>
   */
  public static final class ProvisionServiceFutureStub extends io.grpc.stub.AbstractStub<ProvisionServiceFutureStub> {
    private ProvisionServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ProvisionServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ProvisionServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ProvisionServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Get provision information for the SDK harness worker instance.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoResponse> getProvisionInfo(
        org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_GET_PROVISION_INFO, getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_PROVISION_INFO = 0;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final ProvisionServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(ProvisionServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_PROVISION_INFO:
          serviceImpl.getProvisionInfo((org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.beam.fn.v1.ProvisionApi.GetProvisionInfoResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static final class ProvisionServiceDescriptorSupplier implements io.grpc.protobuf.ProtoFileDescriptorSupplier {
    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return org.apache.beam.fn.v1.ProvisionApi.getDescriptor();
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (ProvisionServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new ProvisionServiceDescriptorSupplier())
              .addMethod(METHOD_GET_PROVISION_INFO)
              .build();
        }
      }
    }
    return result;
  }
}
