/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.joinlibrary;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdks.java.extensions.join.library.repackaged.com.google.common.base.Preconditions;

public class Join {
    public static <K, V1, V2> PCollection<KV<K, KV<V1, V2>>> innerJoin(PCollection<KV<K, V1>> leftCollection, PCollection<KV<K, V2>> rightCollection) {
        Preconditions.checkNotNull(leftCollection);
        Preconditions.checkNotNull(rightCollection);
        final TupleTag v1Tuple = new TupleTag();
        final TupleTag v2Tuple = new TupleTag();
        PCollection coGbkResultCollection = (PCollection)KeyedPCollectionTuple.of((TupleTag)v1Tuple, leftCollection).and(v2Tuple, rightCollection).apply((PTransform)CoGroupByKey.create());
        return ((PCollection)coGbkResultCollection.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<K, CoGbkResult>, KV<K, KV<V1, V2>>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                KV e = (KV)c.element();
                Iterable leftValuesIterable = ((CoGbkResult)e.getValue()).getAll(v1Tuple);
                Iterable rightValuesIterable = ((CoGbkResult)e.getValue()).getAll(v2Tuple);
                for (Object leftValue : leftValuesIterable) {
                    for (Object rightValue : rightValuesIterable) {
                        c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of(leftValue, rightValue)));
                    }
                }
            }
        }))).setCoder((Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getKeyCoder(), (Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getValueCoder(), (Coder)((KvCoder)rightCollection.getCoder()).getValueCoder())));
    }

    public static <K, V1, V2> PCollection<KV<K, KV<V1, V2>>> leftOuterJoin(PCollection<KV<K, V1>> leftCollection, PCollection<KV<K, V2>> rightCollection, final V2 nullValue) {
        Preconditions.checkNotNull(leftCollection);
        Preconditions.checkNotNull(rightCollection);
        Preconditions.checkNotNull(nullValue);
        final TupleTag v1Tuple = new TupleTag();
        final TupleTag v2Tuple = new TupleTag();
        PCollection coGbkResultCollection = (PCollection)KeyedPCollectionTuple.of((TupleTag)v1Tuple, leftCollection).and(v2Tuple, rightCollection).apply((PTransform)CoGroupByKey.create());
        return ((PCollection)coGbkResultCollection.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<K, CoGbkResult>, KV<K, KV<V1, V2>>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                KV e = (KV)c.element();
                Iterable leftValuesIterable = ((CoGbkResult)e.getValue()).getAll(v1Tuple);
                Iterable rightValuesIterable = ((CoGbkResult)e.getValue()).getAll(v2Tuple);
                for (Object leftValue : leftValuesIterable) {
                    if (rightValuesIterable.iterator().hasNext()) {
                        for (Object rightValue : rightValuesIterable) {
                            c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of(leftValue, rightValue)));
                        }
                        continue;
                    }
                    c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of(leftValue, (Object)nullValue)));
                }
            }
        }))).setCoder((Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getKeyCoder(), (Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getValueCoder(), (Coder)((KvCoder)rightCollection.getCoder()).getValueCoder())));
    }

    public static <K, V1, V2> PCollection<KV<K, KV<V1, V2>>> rightOuterJoin(PCollection<KV<K, V1>> leftCollection, PCollection<KV<K, V2>> rightCollection, final V1 nullValue) {
        Preconditions.checkNotNull(leftCollection);
        Preconditions.checkNotNull(rightCollection);
        Preconditions.checkNotNull(nullValue);
        final TupleTag v1Tuple = new TupleTag();
        final TupleTag v2Tuple = new TupleTag();
        PCollection coGbkResultCollection = (PCollection)KeyedPCollectionTuple.of((TupleTag)v1Tuple, leftCollection).and(v2Tuple, rightCollection).apply((PTransform)CoGroupByKey.create());
        return ((PCollection)coGbkResultCollection.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<K, CoGbkResult>, KV<K, KV<V1, V2>>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                KV e = (KV)c.element();
                Iterable leftValuesIterable = ((CoGbkResult)e.getValue()).getAll(v1Tuple);
                Iterable rightValuesIterable = ((CoGbkResult)e.getValue()).getAll(v2Tuple);
                for (Object rightValue : rightValuesIterable) {
                    if (leftValuesIterable.iterator().hasNext()) {
                        for (Object leftValue : leftValuesIterable) {
                            c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of(leftValue, rightValue)));
                        }
                        continue;
                    }
                    c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of((Object)nullValue, rightValue)));
                }
            }
        }))).setCoder((Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getKeyCoder(), (Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getValueCoder(), (Coder)((KvCoder)rightCollection.getCoder()).getValueCoder())));
    }

    public static <K, V1, V2> PCollection<KV<K, KV<V1, V2>>> fullOuterJoin(PCollection<KV<K, V1>> leftCollection, PCollection<KV<K, V2>> rightCollection, final V1 leftNullValue, final V2 rightNullValue) {
        Preconditions.checkNotNull(leftCollection);
        Preconditions.checkNotNull(rightCollection);
        Preconditions.checkNotNull(leftNullValue);
        Preconditions.checkNotNull(rightNullValue);
        final TupleTag v1Tuple = new TupleTag();
        final TupleTag v2Tuple = new TupleTag();
        PCollection coGbkResultCollection = (PCollection)KeyedPCollectionTuple.of((TupleTag)v1Tuple, leftCollection).and(v2Tuple, rightCollection).apply((PTransform)CoGroupByKey.create());
        return ((PCollection)coGbkResultCollection.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<K, CoGbkResult>, KV<K, KV<V1, V2>>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                block5: {
                    Iterable rightValuesIterable;
                    Iterable leftValuesIterable;
                    KV e;
                    block6: {
                        block4: {
                            e = (KV)c.element();
                            leftValuesIterable = ((CoGbkResult)e.getValue()).getAll(v1Tuple);
                            rightValuesIterable = ((CoGbkResult)e.getValue()).getAll(v2Tuple);
                            if (!leftValuesIterable.iterator().hasNext() || !rightValuesIterable.iterator().hasNext()) break block4;
                            for (Object rightValue : rightValuesIterable) {
                                for (Object leftValue : leftValuesIterable) {
                                    c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of(leftValue, rightValue)));
                                }
                            }
                            break block5;
                        }
                        if (!leftValuesIterable.iterator().hasNext() || rightValuesIterable.iterator().hasNext()) break block6;
                        for (Object leftValue : leftValuesIterable) {
                            c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of(leftValue, (Object)rightNullValue)));
                        }
                        break block5;
                    }
                    if (leftValuesIterable.iterator().hasNext() || !rightValuesIterable.iterator().hasNext()) break block5;
                    for (Object rightValue : rightValuesIterable) {
                        c.output((Object)KV.of((Object)e.getKey(), (Object)KV.of((Object)leftNullValue, rightValue)));
                    }
                }
            }
        }))).setCoder((Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getKeyCoder(), (Coder)KvCoder.of((Coder)((KvCoder)leftCollection.getCoder()).getValueCoder(), (Coder)((KvCoder)rightCollection.getCoder()).getValueCoder())));
    }
}

