/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.remote.Service;

class RemoteMeta
extends MetaImpl {
    final Service service;
    final Map<String, ConnectionPropertiesImpl> propsMap = new HashMap<String, ConnectionPropertiesImpl>();

    public RemoteMeta(AvaticaConnection connection, Service service) {
        super(connection);
        this.service = service;
    }

    private Meta.MetaResultSet toResultSet(Class clazz, Service.ResultSetResponse response) {
        if (response.updateCount != -1) {
            return Meta.MetaResultSet.count(response.connectionId, response.statementId, response.updateCount);
        }
        Meta.Signature signature0 = response.signature;
        if (signature0 == null) {
            List<ColumnMetaData> columns = clazz == null ? Collections.emptyList() : RemoteMeta.fieldMetaData((Class)clazz).columns;
            signature0 = Meta.Signature.create(columns, "?", Collections.emptyList(), Meta.CursorFactory.ARRAY);
        }
        return Meta.MetaResultSet.create(response.connectionId, response.statementId, response.ownStatement, signature0, response.firstFrame);
    }

    @Override
    public Meta.StatementHandle createStatement(Meta.ConnectionHandle ch) {
        this.connectionSync(ch, new ConnectionPropertiesImpl());
        Service.CreateStatementResponse response = this.service.apply(new Service.CreateStatementRequest(ch.id));
        return new Meta.StatementHandle(response.connectionId, response.statementId, null);
    }

    @Override
    public void closeStatement(Meta.StatementHandle h) {
        Service.CloseStatementResponse response = this.service.apply(new Service.CloseStatementRequest(h.connectionId, h.id));
    }

    @Override
    public void closeConnection(Meta.ConnectionHandle ch) {
        Service.CloseConnectionResponse response = this.service.apply(new Service.CloseConnectionRequest(ch.id));
        this.propsMap.remove(ch.id);
    }

    @Override
    public Meta.ConnectionProperties connectionSync(Meta.ConnectionHandle ch, Meta.ConnectionProperties connProps) {
        ConnectionPropertiesImpl localProps = this.propsMap.get(ch.id);
        if (localProps == null) {
            localProps = new ConnectionPropertiesImpl();
            localProps.setDirty(true);
            this.propsMap.put(ch.id, localProps);
        }
        if (localProps.merge(connProps).isDirty() && connProps.isEmpty()) {
            Service.ConnectionSyncResponse response = this.service.apply(new Service.ConnectionSyncRequest(ch.id, localProps));
            this.propsMap.put(ch.id, (ConnectionPropertiesImpl)response.connProps);
            return response.connProps;
        }
        return localProps;
    }

    @Override
    public Meta.MetaResultSet getCatalogs() {
        Service.ResultSetResponse response = this.service.apply(new Service.CatalogsRequest());
        return this.toResultSet(MetaImpl.MetaCatalog.class, response);
    }

    @Override
    public Meta.MetaResultSet getSchemas(String catalog, Meta.Pat schemaPattern) {
        Service.ResultSetResponse response = this.service.apply(new Service.SchemasRequest(catalog, schemaPattern.s));
        return this.toResultSet(MetaImpl.MetaSchema.class, response);
    }

    @Override
    public Meta.MetaResultSet getTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        Service.ResultSetResponse response = this.service.apply(new Service.TablesRequest(catalog, schemaPattern.s, tableNamePattern.s, typeList));
        return this.toResultSet(MetaImpl.MetaTable.class, response);
    }

    @Override
    public Meta.MetaResultSet getTableTypes() {
        Service.ResultSetResponse response = this.service.apply(new Service.TableTypesRequest());
        return this.toResultSet(MetaImpl.MetaTableType.class, response);
    }

    @Override
    public Meta.MetaResultSet getColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        Service.ResultSetResponse response = this.service.apply(new Service.ColumnsRequest(catalog, schemaPattern.s, tableNamePattern.s, columnNamePattern.s));
        return this.toResultSet(MetaImpl.MetaColumn.class, response);
    }

    @Override
    public Meta.StatementHandle prepare(Meta.ConnectionHandle ch, String sql, int maxRowCount) {
        this.connectionSync(ch, new ConnectionPropertiesImpl());
        Service.PrepareResponse response = this.service.apply(new Service.PrepareRequest(ch.id, sql, maxRowCount));
        return response.statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Meta.ExecuteResult prepareAndExecute(Meta.ConnectionHandle ch, String sql, int maxRowCount, Meta.PrepareCallback callback) {
        this.connectionSync(ch, new ConnectionPropertiesImpl());
        try {
            Service.ExecuteResponse response;
            Object object = callback.getMonitor();
            synchronized (object) {
                callback.clear();
                response = this.service.apply(new Service.PrepareAndExecuteRequest(ch.id, sql, maxRowCount));
                if (response.results.size() > 0) {
                    Service.ResultSetResponse result = response.results.get(0);
                    callback.assign(result.signature, result.firstFrame, result.updateCount);
                }
            }
            callback.execute();
            ArrayList<Meta.MetaResultSet> metaResultSets = new ArrayList<Meta.MetaResultSet>();
            for (Service.ResultSetResponse result : response.results) {
                metaResultSets.add(this.toResultSet(null, result));
            }
            return new Meta.ExecuteResult(metaResultSets);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Meta.Frame fetch(Meta.StatementHandle h, List<Object> parameterValues, int offset, int fetchMaxRowCount) {
        Service.FetchResponse response = this.service.apply(new Service.FetchRequest(h.connectionId, h.id, parameterValues, offset, fetchMaxRowCount));
        return response.frame;
    }
}

