/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.aws2.clients;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import org.apache.camel.test.infra.aws2.common.SystemPropertiesAWSCredentialsProvider;
import org.apache.camel.test.infra.aws2.common.TestAWSCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sts.StsClient;

public final class AWSSDKClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AWSSDKClientUtils.class);

    private AWSSDKClientUtils() {
    }

    private static URI getEndpoint() {
        String amazonHost = System.getProperty("aws.host");
        if (amazonHost == null || amazonHost.isEmpty()) {
            return null;
        }
        try {
            return new URI(String.format("http://%s", amazonHost));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid endpoint");
        }
    }

    private static boolean isLocalContainer(String awsInstanceType) {
        return awsInstanceType == null || awsInstanceType.equals("local-aws-container");
    }

    private static <T extends AwsClientBuilder, Y extends SdkClient> Y newClient(String property, String name, Supplier<T> clientBuilderSupplier, Class<Y> yClass) {
        Object o;
        AwsClientBuilder clientBuilder = (AwsClientBuilder)clientBuilderSupplier.get();
        LOG.debug("Creating a new AWS v2 {} client", (Object)name);
        String awsInstanceType = System.getProperty(property);
        clientBuilder.region(Region.US_EAST_1);
        URI endpoint = AWSSDKClientUtils.getEndpoint();
        if (AWSSDKClientUtils.isLocalContainer(awsInstanceType) || endpoint != null) {
            clientBuilder.endpointOverride(endpoint);
        }
        if (AWSSDKClientUtils.isLocalContainer(awsInstanceType)) {
            clientBuilder.credentialsProvider((AwsCredentialsProvider)TestAWSCredentialsProvider.CONTAINER_LOCAL_DEFAULT_PROVIDER);
        } else {
            clientBuilder.credentialsProvider((AwsCredentialsProvider)new SystemPropertiesAWSCredentialsProvider());
        }
        if (clientBuilder instanceof S3ClientBuilder) {
            ((S3ClientBuilder)clientBuilder).forcePathStyle(Boolean.valueOf(true));
        }
        if (yClass.isInstance(o = clientBuilder.build())) {
            return (Y)((SdkClient)o);
        }
        throw new UnsupportedOperationException("Invalid class type for AWS client");
    }

    private static <T extends AwsClientBuilder, Y extends SdkClient> Y newClient(String name, Supplier<T> clientBuilderSupplier, Class<Y> yClass) {
        return AWSSDKClientUtils.newClient("aws-service.instance.type", name, clientBuilderSupplier, yClass);
    }

    public static KinesisClient newKinesisClient() {
        return AWSSDKClientUtils.newClient("aws-service.kinesis.instance.type", "Kinesis", KinesisClient::builder, KinesisClient.class);
    }

    public static SqsClient newSQSClient() {
        return AWSSDKClientUtils.newClient("SQS", SqsClient::builder, SqsClient.class);
    }

    public static S3Client newS3Client() {
        return AWSSDKClientUtils.newClient("S3", S3Client::builder, S3Client.class);
    }

    public static SnsClient newSNSClient() {
        return AWSSDKClientUtils.newClient("SNS", SnsClient::builder, SnsClient.class);
    }

    public static CloudWatchClient newCloudWatchClient() {
        return AWSSDKClientUtils.newClient("Cloud Watch", CloudWatchClient::builder, CloudWatchClient.class);
    }

    public static Ec2Client newEC2Client() {
        return AWSSDKClientUtils.newClient("EC2", Ec2Client::builder, Ec2Client.class);
    }

    public static EventBridgeClient newEventBridgeClient() {
        return AWSSDKClientUtils.newClient("EventBridge", EventBridgeClient::builder, EventBridgeClient.class);
    }

    public static IamClient newIAMClient() {
        return AWSSDKClientUtils.newClient("EventBridge", IamClient::builder, IamClient.class);
    }

    public static KmsClient newKMSClient() {
        return AWSSDKClientUtils.newClient("KMS", KmsClient::builder, KmsClient.class);
    }

    public static LambdaClient newLambdaClient() {
        return AWSSDKClientUtils.newClient("Lambda", LambdaClient::builder, LambdaClient.class);
    }

    public static SecretsManagerClient newSecretsManagerClient() {
        return AWSSDKClientUtils.newClient("SecretsManager", SecretsManagerClient::builder, SecretsManagerClient.class);
    }

    public static StsClient newSTSClient() {
        return AWSSDKClientUtils.newClient("STS", StsClient::builder, StsClient.class);
    }

    public static DynamoDbClient newDynamoDBClient() {
        return AWSSDKClientUtils.newClient("DynamoDB", DynamoDbClient::builder, DynamoDbClient.class);
    }
}

