/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.aws2.services;

import java.net.URI;
import java.util.Properties;
import org.apache.camel.test.infra.aws.common.services.AWSService;
import org.apache.camel.test.infra.aws2.services.AWSContainer;
import org.apache.camel.test.infra.aws2.services.Service;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.regions.Region;

public abstract class AWSLocalContainerService
implements AWSService,
ContainerService<AWSContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AWSLocalContainerService.class);
    private final AWSContainer container;

    public AWSLocalContainerService(Service ... services) {
        this(System.getProperty("aws.container", "localstack/localstack:1.3.0"), services);
    }

    public AWSLocalContainerService(AWSContainer container) {
        this.container = container;
    }

    public AWSLocalContainerService(String imageName, Service ... services) {
        this.container = this.initContainer(imageName, new Service[0]);
        this.container.setupServices(services);
    }

    protected AWSContainer initContainer(String imageName, Service ... services) {
        return new AWSContainer(imageName, services);
    }

    private String getAmazonHost() {
        return this.container.getAmazonHost();
    }

    public AWSContainer getContainer() {
        return this.container;
    }

    public Properties getConnectionProperties() {
        Properties properties = new Properties();
        AwsCredentials credentials = this.container.getCredentialsProvider().resolveCredentials();
        properties.put("aws.access.key", credentials.accessKeyId());
        properties.put("aws.secret.key", credentials.secretAccessKey());
        properties.put("aws.region", Region.US_EAST_1.toString());
        properties.put("aws.host", this.container.getAmazonHost());
        properties.put("aws.protocol", "http");
        return properties;
    }

    public URI getServiceEndpoint() {
        return this.container.getServiceEndpoint();
    }

    public void registerProperties() {
        AwsCredentials credentials = this.container.getCredentialsProvider().resolveCredentials();
        System.setProperty("aws.host", this.getAmazonHost());
        System.setProperty("aws.secret.key", credentials.secretAccessKey());
        System.setProperty("aws.access.key", credentials.accessKeyId());
        System.setProperty("aws.host", this.getAmazonHost());
        System.setProperty("aws.region", Region.US_EAST_1.toString());
        System.setProperty("aws.protocol", "http");
    }

    public void initialize() {
        LOG.debug("Trying to start the container");
        this.container.start();
        this.registerProperties();
        LOG.info("AWS service running at address {}", (Object)this.getServiceEndpoint());
    }

    public void shutdown() {
        LOG.info("Stopping the local AWS services");
        this.container.stop();
    }
}

