/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Collection;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.SchemaKeyspace;
import org.apache.cassandra.service.MigrationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationRequestVerbHandler
implements IVerbHandler {
    private static final Logger logger = LoggerFactory.getLogger(MigrationRequestVerbHandler.class);

    public void doVerb(MessageIn message, int id) {
        logger.trace("Received migration request from {}.", (Object)message.from);
        MessageOut<Collection<Mutation>> response = new MessageOut<Collection<Mutation>>(MessagingService.Verb.INTERNAL_RESPONSE, SchemaKeyspace.convertSchemaToMutations(), MigrationManager.MigrationsSerializer.instance);
        MessagingService.instance().sendReply(response, id, message.from);
    }
}

