/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.AbstractCommitLogService;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;

class BatchCommitLogService
extends AbstractCommitLogService {
    public BatchCommitLogService(CommitLog commitLog) {
        super(commitLog, "COMMIT-LOG-WRITER", (int)DatabaseDescriptor.getCommitLogSyncBatchWindow());
    }

    @Override
    protected void maybeWaitForSync(CommitLogSegment.Allocation alloc) {
        this.pending.incrementAndGet();
        this.haveWork.release();
        alloc.awaitDiskSync(this.commitLog.metrics.waitingOnCommit);
        this.pending.decrementAndGet();
    }
}

