/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RowIterators {
    private static final Logger logger = LoggerFactory.getLogger(RowIterators.class);

    private RowIterators() {
    }

    public static void digest(RowIterator iterator, MessageDigest digest) {
        digest.update(iterator.partitionKey().getKey().duplicate());
        iterator.columns().digest(digest);
        FBUtilities.updateWithBoolean(digest, iterator.isReverseOrder());
        iterator.staticRow().digest(digest);
        while (iterator.hasNext()) {
            ((Row)iterator.next()).digest(digest);
        }
    }

    public static RowIterator loggingIterator(RowIterator iterator, final String id) {
        final CFMetaData metadata = iterator.metadata();
        logger.info("[{}] Logging iterator on {}.{}, partition key={}, reversed={}", new Object[]{id, metadata.ksName, metadata.cfName, metadata.getKeyValidator().getString(iterator.partitionKey().getKey()), iterator.isReverseOrder()});
        class Log
        extends Transformation {
            Log() {
            }

            @Override
            public Row applyToStatic(Row row) {
                if (!row.isEmpty()) {
                    logger.info("[{}] {}", (Object)id, (Object)row.toString(metadata));
                }
                return row;
            }

            @Override
            public Row applyToRow(Row row) {
                logger.info("[{}] {}", (Object)id, (Object)row.toString(metadata));
                return row;
            }
        }
        return Transformation.apply(iterator, new Log());
    }
}

