/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableTxnWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.utils.Pair;

abstract class AbstractSSTableSimpleWriter
implements Closeable {
    protected final File directory;
    protected final CFMetaData metadata;
    protected final PartitionColumns columns;
    protected SSTableFormat.Type formatType = DatabaseDescriptor.getSSTableFormat();
    protected static AtomicInteger generation = new AtomicInteger(0);

    protected AbstractSSTableSimpleWriter(File directory, CFMetaData metadata, PartitionColumns columns) {
        this.metadata = metadata;
        this.directory = directory;
        this.columns = columns;
    }

    protected void setSSTableFormatType(SSTableFormat.Type type) {
        this.formatType = type;
    }

    protected SSTableTxnWriter createWriter() {
        return SSTableTxnWriter.create(this.metadata, AbstractSSTableSimpleWriter.createDescriptor(this.directory, this.metadata.ksName, this.metadata.cfName, this.formatType), 0L, 0L, 0, new SerializationHeader(true, this.metadata, this.columns, EncodingStats.NO_STATS), Collections.emptySet());
    }

    private static Descriptor createDescriptor(File directory, String keyspace, String columnFamily, SSTableFormat.Type fmt) {
        int maxGen = AbstractSSTableSimpleWriter.getNextGeneration(directory, columnFamily);
        return new Descriptor(directory, keyspace, columnFamily, maxGen + 1, fmt);
    }

    private static int getNextGeneration(File directory, final String columnFamily) {
        final HashSet existing = new HashSet();
        directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Descriptor desc;
                Pair<Descriptor, Component> p = SSTable.tryComponentFromFilename(dir, name);
                Descriptor descriptor = desc = p == null ? null : (Descriptor)p.left;
                if (desc == null) {
                    return false;
                }
                if (desc.cfname.equals(columnFamily)) {
                    existing.add(desc);
                }
                return false;
            }
        });
        int maxGen = generation.getAndIncrement();
        for (Descriptor desc : existing) {
            while (desc.generation > maxGen) {
                maxGen = generation.getAndIncrement();
            }
        }
        return maxGen;
    }

    PartitionUpdate getUpdateFor(ByteBuffer key) throws IOException {
        return this.getUpdateFor(this.metadata.decorateKey(key));
    }

    abstract PartitionUpdate getUpdateFor(DecoratedKey var1) throws IOException;
}

