/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.SequentialWriter;

public class ChecksummedSequentialWriter
extends SequentialWriter {
    private final SequentialWriter crcWriter;
    private final DataIntegrityMetadata.ChecksumWriter crcMetadata;

    public ChecksummedSequentialWriter(File file, int bufferSize, File crcPath) {
        super(file, bufferSize, BufferType.ON_HEAP);
        this.crcWriter = new SequentialWriter(crcPath, 8192, BufferType.ON_HEAP);
        this.crcMetadata = new DataIntegrityMetadata.ChecksumWriter(this.crcWriter);
        this.crcMetadata.writeChunkSize(this.buffer.capacity());
    }

    @Override
    protected void flushData() {
        super.flushData();
        ByteBuffer toAppend = this.buffer.duplicate();
        toAppend.position(0);
        toAppend.limit(this.buffer.position());
        this.crcMetadata.appendDirect(toAppend, false);
    }

    @Override
    protected SequentialWriter.TransactionalProxy txnProxy() {
        return new TransactionalProxy();
    }

    protected class TransactionalProxy
    extends SequentialWriter.TransactionalProxy {
        protected TransactionalProxy() {
            super(ChecksummedSequentialWriter.this);
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            return super.doCommit(ChecksummedSequentialWriter.this.crcWriter.commit(accumulate));
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            return super.doAbort(ChecksummedSequentialWriter.this.crcWriter.abort(accumulate));
        }

        @Override
        protected void doPrepare() {
            ChecksummedSequentialWriter.this.syncInternal();
            if (ChecksummedSequentialWriter.this.descriptor != null) {
                ChecksummedSequentialWriter.this.crcMetadata.writeFullChecksum(ChecksummedSequentialWriter.this.descriptor);
            }
            ChecksummedSequentialWriter.this.crcWriter.setDescriptor(ChecksummedSequentialWriter.this.descriptor).prepareToCommit();
        }
    }
}

