/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.net.SocketException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JVMStabilityInspector {
    private static final Logger logger = LoggerFactory.getLogger(JVMStabilityInspector.class);
    private static Killer killer = new Killer();

    private JVMStabilityInspector() {
    }

    public static void inspectThrowable(Throwable t) {
        boolean isUnstable = false;
        if (t instanceof OutOfMemoryError) {
            isUnstable = true;
        }
        if (DatabaseDescriptor.getDiskFailurePolicy() == Config.DiskFailurePolicy.die && (t instanceof FSError || t instanceof CorruptSSTableException)) {
            isUnstable = true;
        }
        if ((t instanceof FileNotFoundException || t instanceof SocketException) && t.getMessage().contains("Too many open files")) {
            isUnstable = true;
        }
        if (isUnstable) {
            killer.killCurrentJVM(t);
        }
        if (t.getCause() != null) {
            JVMStabilityInspector.inspectThrowable(t.getCause());
        }
    }

    public static void inspectCommitLogThrowable(Throwable t) {
        if (!StorageService.instance.isSetupCompleted()) {
            logger.error("Exiting due to error while processing commit log during initialization.", t);
            killer.killCurrentJVM(t, true);
        } else if (DatabaseDescriptor.getCommitFailurePolicy() == Config.CommitFailurePolicy.die) {
            killer.killCurrentJVM(t);
        } else {
            JVMStabilityInspector.inspectThrowable(t);
        }
    }

    public static void killCurrentJVM(Throwable t, boolean quiet) {
        killer.killCurrentJVM(t, quiet);
    }

    public static void userFunctionTimeout(Throwable t) {
        switch (DatabaseDescriptor.getUserFunctionTimeoutPolicy()) {
            case die: {
                ScheduledExecutors.nonPeriodicTasks.schedule(() -> killer.killCurrentJVM(t), 250L, TimeUnit.MILLISECONDS);
                break;
            }
            case die_immediate: {
                killer.killCurrentJVM(t);
                break;
            }
            case ignore: {
                logger.error(t.getMessage());
            }
        }
    }

    @VisibleForTesting
    public static Killer replaceKiller(Killer newKiller) {
        Killer oldKiller = killer;
        killer = newKiller;
        return oldKiller;
    }

    @VisibleForTesting
    public static class Killer {
        private final AtomicBoolean killing = new AtomicBoolean();

        protected void killCurrentJVM(Throwable t) {
            this.killCurrentJVM(t, false);
        }

        protected void killCurrentJVM(Throwable t, boolean quiet) {
            if (!quiet) {
                t.printStackTrace(System.err);
                logger.error("JVM state determined to be unstable.  Exiting forcefully due to:", t);
            }
            if (this.killing.compareAndSet(false, true)) {
                StorageService.instance.removeShutdownHook();
                System.exit(100);
            }
        }
    }
}

