/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.ContextAllocator;
import org.apache.cassandra.utils.memory.MemtableAllocator;

public abstract class MemtableBufferAllocator
extends MemtableAllocator {
    protected MemtableBufferAllocator(MemtableAllocator.SubAllocator onHeap, MemtableAllocator.SubAllocator offHeap) {
        super(onHeap, offHeap);
    }

    @Override
    public Row.Builder rowBuilder(OpOrder.Group writeOp) {
        return this.allocator(writeOp).cloningBTreeRowBuilder();
    }

    @Override
    public DecoratedKey clone(DecoratedKey key, OpOrder.Group writeOp) {
        return new BufferDecoratedKey(key.getToken(), this.allocator(writeOp).clone(key.getKey()));
    }

    public abstract ByteBuffer allocate(int var1, OpOrder.Group var2);

    protected AbstractAllocator allocator(OpOrder.Group writeOp) {
        return new ContextAllocator(writeOp, this);
    }
}

