/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.integration;

import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.analysis.integration.UnivariateIntegrator;
import org.apache.commons.math4.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math4.exception.MaxCountExceededException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.TooManyEvaluationsException;
import org.apache.commons.math4.util.IntegerSequence;
import org.apache.commons.math4.util.MathUtils;

public abstract class BaseAbstractUnivariateIntegrator
implements UnivariateIntegrator {
    public static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-15;
    public static final double DEFAULT_RELATIVE_ACCURACY = 1.0E-6;
    public static final int DEFAULT_MIN_ITERATIONS_COUNT = 3;
    public static final int DEFAULT_MAX_ITERATIONS_COUNT = Integer.MAX_VALUE;
    protected IntegerSequence.Incrementor iterations;
    private final double absoluteAccuracy;
    private final double relativeAccuracy;
    private final int minimalIterationCount;
    private final int maximalIterationCount;
    private IntegerSequence.Incrementor evaluations;
    private UnivariateFunction function;
    private double min;
    private double max;

    protected BaseAbstractUnivariateIntegrator(double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) {
        this.relativeAccuracy = relativeAccuracy;
        this.absoluteAccuracy = absoluteAccuracy;
        if (minimalIterationCount <= 0) {
            throw new NotStrictlyPositiveException(minimalIterationCount);
        }
        if (maximalIterationCount <= minimalIterationCount) {
            throw new NumberIsTooSmallException(maximalIterationCount, (Number)minimalIterationCount, false);
        }
        this.minimalIterationCount = minimalIterationCount;
        this.maximalIterationCount = maximalIterationCount;
    }

    protected BaseAbstractUnivariateIntegrator(double relativeAccuracy, double absoluteAccuracy) {
        this(relativeAccuracy, absoluteAccuracy, 3, Integer.MAX_VALUE);
    }

    protected BaseAbstractUnivariateIntegrator(int minimalIterationCount, int maximalIterationCount) {
        this(1.0E-6, 1.0E-15, minimalIterationCount, maximalIterationCount);
    }

    @Override
    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    @Override
    public int getMinimalIterationCount() {
        return this.minimalIterationCount;
    }

    @Override
    public int getMaximalIterationCount() {
        return this.iterations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    @Override
    public int getIterations() {
        return this.iterations.getCount();
    }

    protected double getMin() {
        return this.min;
    }

    protected double getMax() {
        return this.max;
    }

    protected double computeObjectiveValue(double point) {
        try {
            this.evaluations.increment();
        }
        catch (MaxCountExceededException e) {
            throw new TooManyEvaluationsException(e.getMax());
        }
        return this.function.value(point);
    }

    protected void setup(int maxEval, UnivariateFunction f, double lower, double upper) {
        MathUtils.checkNotNull(f);
        UnivariateSolverUtils.verifyInterval(lower, upper);
        this.min = lower;
        this.max = upper;
        this.function = f;
        this.iterations = IntegerSequence.Incrementor.create().withMaximalCount(this.maximalIterationCount);
        this.evaluations = IntegerSequence.Incrementor.create().withMaximalCount(maxEval);
    }

    @Override
    public double integrate(int maxEval, UnivariateFunction f, double lower, double upper) {
        this.setup(maxEval, f, lower, upper);
        return this.doIntegrate();
    }

    protected abstract double doIntegrate();
}

